<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>CostCode List</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="CostCode"
                                        action="list"
                                        dateFormat="EEE, dd-MMM-yyyy"
                                        removeImgDir="images"
                                        removeImgFile="bullet_delete.png"
                                        title="Search"/>

            <div class="paginateButtons">
                Results: ${costCodeInstanceList.size()} / ${costCodeInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <br />

            <g:if test="${costCodeInstanceList.size() > 0}">

                <div class="list">
                    <table>
                        <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="name" title="Name" params="${filterParams}" />

                            <g:sortableColumn property="purchasingGroup" title="Group" params="${filterParams}" />

                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <g:each in="${costCodeInstanceList}" status="i" var="costCodeInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                <td onclick='window.location = "${request.getContextPath()}/costCodeDetailed/show/${costCodeInstance.id}"'>
                                    ${fieldValue(bean:costCodeInstance, field:'id')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/costCodeDetailed/show/${costCodeInstance.id}"'>
                                    ${fieldValue(bean:costCodeInstance, field:'name')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/costCodeDetailed/show/${costCodeInstance.id}"'>
                                    ${fieldValue(bean:costCodeInstance, field:'purchasingGroup')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/costCodeDetailed/show/${costCodeInstance.id}"'>
                                    ${fieldValue(bean:costCodeInstance, field:'description')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/costCodeDetailed/show/${costCodeInstance.id}"'>
                                    ${fieldValue(bean:costCodeInstance, field:'isActive')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${costCodeInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <div class="paginateButtons">
                <g:paginate total="${costCodeInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="CostCode"
                                   title="Search"
                                   action="list"
                                   class="overlayPane"
                                   associatedProperties="purchasingGroup.name"
                                   filterPropertyValues="${['purchasingGroup.name':[values: associatedPropertyValues.purchasingGroupList]]}" />

        </div>
    </body>
</html>
