import gnumims.functional.pages.HomePage
import gnumims.functional.pages.LoginPage
import gnumims.functional.pages.LogoutPage
import spock.lang.Stepwise
import spock.lang.Unroll

@Stepwise
class LoginSpec extends GebReportingSpecBase {

    def "We start at the login page"() {
        when:
        go baseUrl

        then:
        at LoginPage
    }

    def "When we login, we go to the home page"() {
        when:
        login('admin', 'pass')

        then:
        at HomePage
    }

    def "When we logout, we go to the logout page"() {
        when:
        logout.click()

        then:
        at LogoutPage
        verifyLogoutMessage()
    }

    //@Unroll("Username: '#username' with password: '#password' should fail to login.")
    def "If we type in the wrong password or username"() {
        expect:
        login(username, password)
        at LoginPage
        verifyLoginFailureMessage()

        where:
        username  | password
        'admin'   | 'bogus' /* Bogus Password. */
        'admin'   | ''      // None.
        'admin'   | ' '      // Blank.
        'admin'   | 'PASS'  // Capitals
        'admin'   | 'Pass'  // First Capital.
        'admin'   | 'pasS'  // Last Capital.
        'admin'   | 'pas'   // One letter short.
        'admin'   | 'passs' // One letter longer.
        'admin'   | ' pass' // Leading space.
        'admin'   | 'pass ' // Trailing space.
        'admin'   | '*'     // Star Wildcard.
        'admin'   | '%'     // Percentage Wildcard.
        'admin'   | '.'     // Dot Wildcard.
        'admin'   | 'pas*'  // Star Wildcard in pattern.
        'admin'   | 'pas%'  // Percentage Wildcard in pattern.
        'bogus'   | 'pass'  /* Bogus Username. */
        ''        | 'pass'  // None
        ' '       | 'pass'  // Blank
        'ADMIN'   | 'pass'  // Capitals
        'Admin'   | 'pass'  // First Capital.
        'admiN'   | 'pass'  // Last Capital.
        'admi'    | 'pass'  // One letter short.
        'adminn'  | 'pass'  // One letter longer.
        //' admin'  | 'pass' // Leading space.
        //'admin '  | 'pass' // Trailing space.
        '*'       | 'pass'  // Star Wildcard.
        '%'       | 'pass'  // Percentage Wildcard.
        '.'       | 'pass'     // Dot Wildcard.
        'admi*'   | 'pass'  // Star Wildcard in pattern.
        'admi%'   | 'pass'  // Percentage Wildcard in pattern.
    }

}
