import gnumims.functional.pages.HomePage
import gnumims.functional.pages.LoginPage
import gnumims.functional.pages.LogoutPage
import spock.lang.Stepwise

@Stepwise
class LoginSpec extends GebReportingSpecBase {

    def "We start at the login page"() {
        when:
        go baseUrl

        then:
        at LoginPage
    }

    def "When we login, we go to the home page"() {
        when:
        login('admin', 'pass')

        then:
        at HomePage
    }

    def "When we logout, we go to the logout page"() {
        when:
        logout.click()

        then:
        at LogoutPage
        verifyLogoutMessage()
    }

    def "If we type in the wrong password"() {
        when:
        login('admin', 'bogus')

        then:
        at LoginPage
        verifyLoginFailureMessage()
    }

}
