import gnumims.functional.pages.HomePage
import gnumims.functional.pages.LoginPage
import gnumims.functional.pages.LogoutPage
import spock.lang.Stepwise

@Stepwise
class LoginSpec extends GebReportingSpecBase {

    def "We start at the login page"() {
        when:
        go baseUrl

        then:
        at LoginPage
    }

    def "When we click login we go to the home page"() {
        when:
        to LoginPage
        form.j_username = "admin"
        form.j_password = "pass"
        login.click()

        then:
        at HomePage
    }

    def "When we click logout, we go to the logout page"() {
        when:
        logout.click()

        then:
        at LogoutPage
        verifyLogoutMessage()
    }

    def "If we type in the wrong password"() {
        when:
        to LoginPage
        form.j_username = "admin"
        form.j_password = "bogus"
        login.click()

        then:
        at LoginPage
        verifyLoginFailureMessage()
    }

}
