import gnumims.functional.pages.HomePage
import gnumims.functional.pages.LoginPage
import spock.lang.Stepwise

@Stepwise
class LoginSpec extends GebReportingSpecBase {

    def "We start at the login page"() {
        when:
        go getBaseUrl()

        then:
        $("h1").text() == "Welcome to gnuMims please log in"
    }

    def "When we click login we go to the home page"() {
        when:
        to LoginPage
        form.j_username = "admin"
        form.j_password = "pass"
        login.click(HomePage)

        then:
        at(HomePage)
    }

    def "When we click logout, we go back to the login page"() {
        when:
        to HomePage
        logout.click()

        then:
        at(LoginPage)
    }

    def "If we type in the wrong password"() {
        when:
        to LoginPage
        form.j_username = "admin"
        form.j_password = "bogus"
        login.click(LoginPage)

        then:
        $("div.login_message").text() == "[admin] wrong username/password."
    }

}
