<script type="text/javascript">
    var docRef_childCount = ${taskProcedureInstance?.documentReferences.size()} + 0;
    var docRef_wrapperId = "docRef_wrapper";
    var docRef_cloneId = "documentReferenceLazyList_clone";
    var docRef_lazyList = "documentReferenceLazyList";
    var docRef_fields = ["toBeDeleted", "isNew", "name", "location"];
    var docRef_focusField = "name";

    // Click event on add button.
    jQuery('.add-docRef').live('click', function() {
        addChild(docRef_wrapperId, docRef_cloneId, docRef_lazyList, docRef_fields, docRef_focusField, docRef_childCount);
        docRef_childCount++;
    });

    // Click event on delete buttons.
    jQuery('.del-docRef').live('click', function() {
        //find the parent div
        var prnt = jQuery(this).parents(".docRef-div");
        //find the deleted hidden input
        var delInput = prnt.find("input[id$=toBeDeleted]");
        //check if this is still not persisted
        var newValue = prnt.find("input[id$=isNew]").attr('value');
        //if it is new then i can safely remove from dom
        if(newValue == 'true'){
            prnt.remove();
        }else{
            //set the deletedFlag to true
            delInput.attr('value','true');
            //hide the div
            prnt.hide();
        }
    });

</script>

    <div>
        <table>
            <thead>
                <tr>

                    <th>Document Reference Name</th>
                    <th>Location</th>
                    <th></th>

                </tr>
            </thead>
            <tbody id="docRef_wrapper">
                <g:each var="docRef" in="${taskProcedureInstance.documentReferences}" status="i">
                        <g:render template="documentReference" model="['docRef': docRef,
                                                                                                                    'i':i]" />
                </g:each>
            </tbody>
        </table>
    </div>

    <br />

    <div style="text-align:right;">
        <span class="buttons add-docRef">
            <input type="button" class="add" value="Add Document Ref" />
        </span>
    </div>
