

    <g:render template="/shared/messages" />
    <g:hasErrors bean="${entryInstance}">
        <div class="errors">
            <g:renderErrors bean="${entryInstance}" as="list" />
        </div>
    </g:hasErrors>
    <div class="pane_close">
        <img  src="${resource(dir:'images/skin',file:'cross.png')}" alt="Close" title="Close"/>
    </div>
    <g:form action="ajaxSave" method="post" name="createEntryForm">
        <g:hiddenField name="task.id" value="${entryInstance.task.id}" />
        <g:hiddenField name="entryType.id" value="${entryInstance.entryType.id}" />
        <g:hiddenField name="submitAction" value="save" />
        <div class="dialog">
            <table>
                <tbody>

                    <g:if test="${entryInstance?.entryType?.id == 1}">
                        <tr class="prop">
                            <td valign="top" class="name">
                                <label for="productionReference">Production:</label>
                            </td>
                            <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'productionReference','errors')}">
                                <g:select optionKey="id"
                                                    from="${ProductionReference.findAllByIsActive(true)}"
                                                    name="productionReference.id"
                                                    value="${entryInstance.productionReference?.id}"
                                                    noSelection="['null':'--None--']">
                                </g:select>
                                <custom:helpBalloon code="entry.productionReference.fault" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </td>
                        </tr>
                    </g:if>

                    <g:if test="${entryInstance?.entryType?.id == 6}">
                        <tr class="prop">
                            <td valign="top" class="name">
                                <label for="highestSeverity">Condition Severity:</label>
                            </td>
                            <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'highestSeverity','errors')}">
                                <g:select optionKey="id"
                                                    from="${ConditionSeverity.findAllByIsActive(true)}"
                                                    name="highestSeverity.id"
                                                    value="${entryInstance.highestSeverity?.id}"
                                                    noSelection="['null':/${g.message(code:'default.please.select.text')}/]" >
                                </g:select>
                                <custom:helpBalloon code="entry.comment.pm.entry" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </td>
                        </tr>
                    </g:if>

                    <tr class="prop">
                        <td valign="top" class="name">
                            <label for="comment">${entryInstance?.entryType.encodeAsHTML()}:</label>
                        </td>
                        <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'comment','errors')}">
                            <textarea rows="5" cols="40" name="comment">${fieldValue(bean:entryInstance, field:'comment')}</textarea>
                            <g:if test="${entryInstance?.entryType?.id == 1}">
                                <custom:helpBalloon code="entry.comment.fault" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </g:if>
                            <g:elseif test="${entryInstance?.entryType?.id == 2}">
                                <custom:helpBalloon code="entry.comment.cause" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </g:elseif>
                            <g:elseif test="${entryInstance?.entryType?.id == 3}">
                                <custom:helpBalloon code="entry.comment.work.done" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </g:elseif>
                            <g:elseif test="${entryInstance?.entryType?.id == 6}">
                                <custom:helpBalloon code="entry.comment.pm.entry" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </g:elseif>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">
                            <label for="dateDone">Date Done:</label>
                        </td>
                        <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'dateDone','errors')}">
                            <richui:dateChooser name="dateDone" format="dd-MM-yyyy" value="${entryInstance.dateDone}" />
                            <custom:helpBalloon code="entry.date.done" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                        </td>
                    </tr>

                    <g:if test="${entryInstance?.entryType?.id != 2}">
                        <tr class="prop">
                            <td valign="top" class="name">
                                <label for="durationHour">Duration:</label>
                            </td>

                            <td valign="top" class="value">
                                <input class="time ${hasErrors(bean:entryInstance,field:'durationHour','errors')}"
                                    type="text" id="durationHour" name="durationHour"
                                    value="${fieldValue(bean:entryInstance,field:'durationHour')}" />
                                :
                                <input class="time ${hasErrors(bean:entryInstance,field:'durationMinute','errors')}"
                                    type="text" id="durationMinute" name="durationMinute"
                                    value="${fieldValue(bean:entryInstance,field:'durationMinute')}" />
                                <custom:helpBalloon code="entry.duration" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
                            </td>
                        </tr>
                    </g:if>

                </tbody>
            </table>
        </div>
        <div class="buttons">
            <span class="button">
                <input class="save" type="submit" value="Save" name="submit_default" />
            </span>
            <span class="button">
                <input class="flag" type="button" value="Unresolved" name="submit_andSetAttentionFlag" />
            </span>
            <custom:helpBalloon code="task.status.unresolved" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
            <span class="button">
                <g:if test="${entryInstance.task.attentionFlag}" >
                    <input class="complete"
                                type="button" 
                                value="Resolved"
                                onclick="return confirm('${message(code:'task.clear.attention.flag.on.completion.confirm')}');"
                                name="submit_andComplete"/>
                </g:if>
                <g:else>
                    <input class="complete" type="button" value="Resolved" name="submit_andComplete" />
                </g:else>
            </span>
            <custom:helpBalloon code="task.status.resolved" iconSrc="${resource(plugin:'help-balloons', dir:'images', file:'balloon-icon.gif')}" />
        </div>
    </g:form>
