import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', deleteDetailed:'POST', save:'POST', saveDetailed:'POST', updateDetailed:'POST']

    @Secured(['ROLE_AppAdmin']) 
    def list = {
        if(!params.max) params.max = 10
        [ taskInstanceList: Task.list( params ) ]
    }

    def listDetailed = {
        if(!params.max) params.max = 10
        [ taskInstanceList: Task.list( params ) ]
    }

    @Secured(['ROLE_AppAdmin']) 
    def show = {
        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskInstance : taskInstance ] }
    }

    def showDetailed = {
        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskInstance : taskInstance ] }
    }

    @Secured(['ROLE_AppAdmin'])     
    def delete = {
        def taskInstance = Task.get( params.id )
        if(taskInstance) {
            taskInstance.delete()
            flash.message = "Task ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def deleteDetailed = {
        def taskInstance = Task.get( params.id )
        if(taskInstance) {
            taskInstance.delete()
            flash.message = "Task ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
    }

    @Secured(['ROLE_AppAdmin']) 
    def edit = {
        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskInstance : taskInstance ]
        }
    }

    def editDetailed = {
        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            def criteria = taskInstance.createCriteria()
            def results = criteria {
                and {
                    notEqual('id', taskInstance.id)
                    }
            }
            return [ taskInstance : taskInstance, possibleParentList: results ]
        }
    }

    @Secured(['ROLE_AppAdmin']) 
    def update = {
        def taskInstance = Task.get( params.id )
        if(taskInstance) {
            taskInstance.properties = params
            if(!taskInstance.hasErrors() && taskInstance.save()) {
                flash.message = "Task ${params.id} updated"
                redirect(action:show,id:taskInstance.id)
            }
            else {
                render(view:'edit',model:[taskInstance:taskInstance])
            }
        }
        else {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def updateDetailed = {
        def taskInstance = Task.get( params.id )
        if(taskInstance) {
            taskInstance.properties = params
            if(!taskInstance.hasErrors() && taskInstance.save()) {
                flash.message = "Task ${params.id} updated"
                redirect(action:show,id:taskInstance.id)
            }
            else {
                render(view:'edit',model:[taskInstance:taskInstance])
            }
        }
        else {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    @Secured(['ROLE_AppAdmin']) 
    def create = {
        def taskInstance = new Task()
        taskInstance.properties = params
        return ['taskInstance':taskInstance]
    }

    def createDetailed = {
        def taskInstance = new Task()
        taskInstance.properties = params
        return ['taskInstance':taskInstance]
    }

    @Secured(['ROLE_AppAdmin']) 
    def save = {
        def taskInstance = new Task(params)
        if(!taskInstance.hasErrors() && taskInstance.save()) {
            flash.message = "Task ${taskInstance.id} created"
            redirect(action:show,id:taskInstance.id)
        }
        else {
            render(view:'create',model:[taskInstance:taskInstance])
        }
    }

    def saveDetailed = {
        def taskInstance = new Task(params)
        if(!taskInstance.hasErrors() && taskInstance.save()) {
            flash.message = "Task ${taskInstance.id} created"
            redirect(action:showDetailed,id:taskInstance.id)
        }
        else {
            render(view:'createDetailed',model:[taskInstance:taskInstance])
        }
    }
}
