    <g:if test="${taskInstanceList.size() > 0}">
        <div class="list">
            <table>
                <thead>
                    <tr>

                        <custom:sortableColumnWithImg property="attentionFlag"
                                                                                        imgSrc="${resource(dir:'images/skin',file:'flag_red.png')}"
                                                                                        imgAlt="Flag"
                                                                                        imgTitle="Attention Flag"
                                                                                        params="${filterParams}" />

                        <custom:sortableColumnWithImg property="highestSeverity"
                                                                                        imgSrc="${resource(dir:'images/skin',file:'award_star_silver_3.png')}"
                                                                                        imgAlt="Severity"
                                                                                        imgTitle="Highest Severity"
                                                                                        params="${filterParams}" />

                        <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />

                        <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                        <g:sortableColumn property="taskGroup" title="Group" params="${filterParams}" />

                        <g:sortableColumn  property="taskType" title="Type" params="${filterParams}" />

                        <custom:sortableColumnWithImg property="taskStatus"
                                                                                        imgSrc="${resource(dir:'images/skin',file:'status.png')}"
                                                                                        imgAlt="Status"
                                                                                        imgTitle="Status"
                                                                                        params="${filterParams}" />

                        <g:sortableColumn  property="taskPriority" title="Priority" params="${filterParams}" />

                        <custom:sortableColumnWithImg property="defaultSort"
                                                                                        imgSrc="${resource(dir:'images/skin',file:'table_sort.png')}"
                                                                                        imgAlt="Sort"
                                                                                        imgTitle="Default Sort"
                                                                                        params="${filterParams}" />

                    </tr>
                </thead>
                <tbody>
                <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                        <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            <g:if test="${taskInstance.attentionFlag}">
                                <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Flag" title="Attention Flag"/>
                            </g:if>
                        </td>

                        <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            <g:if test="${taskInstance.highestSeverity}">
                                ${taskInstance.highestSeverity.code.encodeAsHTML()}
                            </g:if>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            <b>
                                Task #${fieldValue(bean:taskInstance, field:'id')}
                            </b>
                            <g:if test="${taskInstance.approved}" >
                                <img  src="${resource(dir:'images/skin',file:'cog.png')}" alt="Approved" title="Approved" />
                            </g:if>
                            <g:if test="${taskInstance.taskRecurringSchedule?.enabled}" >
                                <img  src="${resource(dir:'images/skin',file:'arrow_refresh.png')}" alt="Recurrence Enabled" title="Recurrence Enabled" />
                            </g:if>
                            <br />

                            <b>
                            <g:if test="${taskInstance.primaryAsset}">
                                ${fieldValue(bean:taskInstance, field:'primaryAsset')}:
                            </g:if>
                            ${fieldValue(bean:taskInstance, field:'description')}
                            </b>
                            <g:if test="${taskInstance.taskProcedureRevision?.maintenanceActions}" >
                                <br />
                                <custom:taskProcedureMachines taskProcedureRevision="${taskInstance.taskProcedureRevision}" />
                            </g:if>
                            <g:if test="${taskInstance.safetyRequirement}" >
                                <br />
                                <img  src="${resource(dir:'images/skin',file:'lightning.png')}" alt="Safety Requirement" title="Safety Requirement" />
                                Safety
                            </g:if>
                            <g:if test="${taskInstance.regulatoryRequirement}" >
                                <br />
                                <img  src="${resource(dir:'images/skin',file:'script_lightning.png')}" alt="Regulatory Requirement" title="Regulatory Requirement" />
                                Regulatory
                            </g:if>
                            <g:if test="${taskInstance.mandatoryRequirement}" >
                                <br />
                                <img  src="${resource(dir:'images/skin',file:'script.png')}" alt="Mandatory Requirement" title="Mandatory Requirement" />
                                Mandatory
                            </g:if>
                            <br />
                            <br />
                            <g:each in="${taskInstance.assignedGroups}" status="j" var="assignedGroup">
                                ${assignedGroup.encodeAsHTML()}<br />
                            </g:each>
                            <g:each in="${taskInstance.assignedPersons}" status="k" var="assignedPerson">
                                ${assignedPerson.encodeAsHTML()}<br />
                            </g:each>
                            <g:each in="${taskInstance.entries}" status="m" var="entry">
                                <g:if test="${entry.entryType.id == 3}">
                                    <em>${'WD: ' +entry.toShortString().encodeAsHTML()}</em><br />
                                </g:if>
                            </g:each>
                            <g:if test="${taskInstance.subTasks}">
                                Sub Tasks: ${taskInstance.subTasks.size()}<br />
                            </g:if>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            ${fieldValue(bean:taskInstance, field:'taskGroup')}
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            ${fieldValue(bean:taskInstance, field:'taskType')}
                        </td>

                        <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            <g:if test="${taskInstance.taskStatus.id == 1}" >
                                <img  src="${resource(dir:'images/skin',file:'not_started.png')}" alt="Not Started" title="Not Started" />
                            </g:if>
                            <g:if test="${taskInstance.taskStatus.id == 2}" >
                                <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                            </g:if>
                            <g:if test="${taskInstance.taskStatus.id == 3}" >
                                <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                            </g:if>
                        </td>

                        <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                            ${fieldValue(bean:taskInstance, field:'taskPriority')}
                        </td>

                        <td class="notClickable">
                            <g:link action="show" id="${taskInstance.id}">
                                <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                            </g:link>
                        </td>

                    </tr>
                </g:each>
                </tbody>
            </table>
        </div>
    </g:if>