

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show InventoryItem</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:if test="${inventoryItemInstance.isObsolete || !inventoryItemInstance.isActive}" >
                <div class="errors">
                    <ul>
                        <g:if test="${inventoryItemInstance.isObsolete}" >
                            <li><g:message code="inventory.item.is.obsolete" /><li>
                        </g:if>
                        <g:if test="${!inventoryItemInstance.isActive}" >
                            <li><g:message code="inventory.item.not.active" /><li>
                        </g:if>
                    <ul>
                </div>
            </g:if>
            <g:hasErrors bean="${inventoryMovementInstance}">
                <div class="errors">
                    <g:renderErrors bean="${inventoryMovementInstance}" as="list" />
                </div>
            </g:hasErrors>

            <g:hasErrors bean="${inventoryItemInstance}">
                <div class="errors">
                    <g:renderErrors bean="${inventoryItemInstance}" as="list" />
                </div>
            </g:hasErrors>

            <div class="tabHeader">
                <h1>
                    ${inventoryItemInstance.name}
                </h1>
                ${fieldValue(bean:inventoryItemInstance, field:'description')}
            </div>

            <br/>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTab.inventory}" title="Inventory Item" />
                    <richui:tabLabel selected="${showTab.detail}" title="Detail" />
                    <g:if test="${!inventoryMovementList.isEmpty()}">
                        <richui:tabLabel selected="${showTab.movement}" title="Movement (${inventoryMovementList.size()})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.movement}" title="Movement" />
                    </g:else>
                    <g:if test="${!inventoryItemPurchases.isEmpty()}">
                        <richui:tabLabel selected="${showTab.purchasing}" title="Purchasing (${inventoryItemPurchases.size()})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.purchasing}" title="Purchasing" />
                    </g:else>
                </richui:tabLabels>

                <richui:tabContents>

<!-- Start Inventory tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementInstance}" >

                            <div id="useInventoryItemDiv" style="display:inline"> <!-- inline required for IE -->
                                <div class="pane_close" >
                                    <g:remoteLink action="clearUseInventoryItem" update="useInventoryItemDiv">
                                        <img  src="${resource(dir:'images/skin',file:'cross.png')}" alt="Clear" title="Clear"/>
                                    </g:remoteLink>
                                </div>
                                <g:form controller="inventoryItemDetailed" action="useInventoryItem" method="post" >
                                    <div class="dialog">
                                        <table>
                                            <tbody>
                                                    <g:hiddenField name="task.id" value="${inventoryMovementInstance.task.id}"/>
                                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}"/>
                                                    <tr class="prop">
                                                        <td valign="top" class="name">Use on task:</td>
                                                        <td valign="top" class="value">
                                                            <g:link controller="taskDetailed" action="show" id="${inventoryMovementInstance.task.id}" >
                                                                ${Task.get(inventoryMovementInstance.task.id).encodeAsHTML()}
                                                            </g:link>
                                                        </td>
                                                    </tr>

                                                    <tr class="prop">
                                                        <td valign="top" class="name">
                                                            <label for="quantity">Quantity:</label>
                                                        </td>
                                                        <td valign="top">
                                                            <input class="medium ${hasErrors(bean:inventoryMovementInstance,field:'quantity','errors')}"
                                                                        type="text" id="quantity" name="quantity"
                                                                        value="${fieldValue(bean:inventoryMovementInstance,field:'quantity')}"/>
                                                            ${inventoryItemInstance.unitOfMeasure?.encodeAsHTML()}

                                                            <span class="buttons">
                                                                <g:actionSubmit action="useInventoryItem" class="save" value="${InventoryMovementType.read(1)}" />
                                                            </span>

                                                        </td>
                                                    </tr>

                                            </tbody>
                                        </table>
                                    </div>
                                </g:form>

                                <br />
                            </div>

                        </g:if>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">Picture:</td>
                                        <td valign="top" class="value">
                                            <g:if test="${inventoryItemInstance.picture}" >
                                                <span class='gallery'><wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" /></span>
                                            </g:if>
                                            <g:else>
                                                <g:link controller="pictureDetailed"
                                                                params="['inventoryItem.id':inventoryItemInstance.id]"
                                                                action="create">
                                                    Add Picture
                                                </g:link>
                                            </g:else>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Comment:</td>

                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'comment')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">In Stock:</td>

                                        <td valign="top" class="value">
                                            ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')} ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Location:</td>

                                        <td valign="top" class="value">
                                            <g:link controller="inventoryLocationDetailed" action="show" id="${inventoryItemInstance.inventoryLocation?.id}">
                                                ${inventoryItemInstance.inventoryLocation?.encodeAsHTML()}
                                            </g:link>
                                                in ${inventoryItemInstance.inventoryLocation?.inventoryStore.encodeAsHTML()}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Active:</td>

                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isActive')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Items:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${ inventoryItemInstance.alternateItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="inventoryItemDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Spare For:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="s" in="${ inventoryItemInstance.spareFor.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="assetDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="buttons">
                            <g:form>
                                <g:hiddenField name="id" value="${inventoryItemInstance.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>

                        <br />

                    </richui:tabContent>
<!-- End Inventory tab -->

<!-- Start Detail tab -->
                    <richui:tabContent>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">Id:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'id')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Obsolete:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isObsolete')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Inventory Group:</td>
                                        <td valign="top" class="value">${inventoryItemInstance.inventoryGroup?.encodeAsHTML()}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Inventory Type:</td>
                                        <td valign="top" class="value">${inventoryItemInstance.inventoryType?.encodeAsHTML()}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Reorder Point:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'reorderPoint')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Enable Reorder:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'enableReorder')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Recommended Reorder Point:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'recommendedReorderPoint')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Estimated Unit Price:</td>

                                        <td valign="top" class="value">
                                            <g:if test="${inventoryItemInstance.estimatedUnitPriceAmount}">
                                                ${inventoryItemInstance.estimatedUnitPriceAmount.encodeAsHTML()}
                                                ${inventoryItemInstance.estimatedUnitPriceCurrency.encodeAsHTML()}
                                            </g:if>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Suppliers Part Number:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'suppliersPartNumber')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Preferred Supplier:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <g:link controller="supplierDetailed" action="show" id="${inventoryItemInstance.preferredSupplier?.id}">
                                                ${inventoryItemInstance.preferredSupplier?.encodeAsHTML()}
                                            </g:link>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Suppliers:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="s" in="${ inventoryItemInstance.alternateSuppliers.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="supplierDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Average Delivery Time:</td>
                                        <td valign="top" class="value">
                                        ${fieldValue(bean:inventoryItemInstance, field:'averageDeliveryTime')}
                                        ${fieldValue(bean:inventoryItemInstance, field:'averageDeliveryPeriod')}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Manufacturers Part Number:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'manufacturersPartNumber')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Preferred Manufacturer:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <g:link controller="manufacturerDetailed" action="show" id="${inventoryItemInstance.preferredManufacturer?.id}">
                                                ${inventoryItemInstance.preferredManufacturer?.encodeAsHTML()}
                                            </g:link>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Manufacturers:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="m" in="${ inventoryItemInstance.alternateManufacturers.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="manufacturerDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>


                                </tbody>
                            </table>
                        </div>
                        <div class="buttons">
                            <g:form>
                                <g:hiddenField name="id" value="${inventoryItemInstance.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>
                    </richui:tabContent>
<!-- End Detail tab -->

<!-- Start Movement tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementList.isEmpty()}">
                            <br />
                            No Inventory Movements.
                            <br />
                            <br />

                            <div class="buttons">
                                <g:form controller="inventoryMovementDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Create" /></span>
                                </g:form>
                            </div>

                        </g:if>
                        <g:else>

                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Quantity</th>
                                            <th>Movement Type</th>
                                            <th>Date</th>
                                            <th>Person</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${inventoryMovementList}" status="i" var="movements">
                                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${movements.id}"'>
                                                    ${fieldValue(bean:movements, field:'quantity')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${movements.id}"'>
                                                    ${fieldValue(bean:movements, field:'inventoryMovementType')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${movements.id}"'>
                                                    <g:formatDate date="${movements.date}" format="EEE, dd-MMM-yyyy"/>
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${movements.id}"'>
                                                    ${fieldValue(bean:movements, field:'person')}
                                                </td>

                                                <td class="notClickable">
                                                    <g:link controller="inventoryMovementDetailed" action="show" id="${movements.id}">
                                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                                    </g:link>
                                                </td>

                                            </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>

                            <div class="buttons">
                                <g:form controller="inventoryMovementDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    <g:if test="${inventoryMovementListTotal > inventoryMovementListMax}">
                                        Showing ${inventoryMovementListMax} of ${inventoryMovementListTotal}
                                        <br />
                                    </g:if>
                                    <g:else>
                                        Total ${inventoryMovementListTotal}
                                        <br />
                                    </g:else>
                                    <span class="button"><g:actionSubmit action="listInventoryMovements" class="table" value="List" /></span>
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Create" /></span>
                                </g:form>
                            </div>

                        </g:else>

                    </richui:tabContent>
<!-- End Movement tab -->

<!-- Start Purchases tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryItemPurchases.isEmpty()}">
                            <br />
                            No Inventory Purchases.
                            <br />
                            <br />

                            <div class="buttons">
                                <g:form controller="inventoryItemPurchaseDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Order" /></span>
                                </g:form>
                            </div>

                        </g:if>
                        <g:else>

                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <g:sortableColumn action="show" property="purchaseOrderNumber"
                                                                                title="Order #" params="[paginate: 'purchases']"  />
                                            <g:sortableColumn action="show"  property="dateEntered"
                                                                                title="Date" params="[paginate: 'purchases']" />
                                            <g:sortableColumn action="show"  property="costCode"
                                                                                title="Cost Code" params="[paginate: 'purchases']" />
                                            <g:sortableColumn action="show"  property="quantity"
                                                                                title="Quantity" params="[paginate: 'purchases']" />
                                            <g:sortableColumn action="show"  property="orderValueAmount"
                                                                                title="Order \$" params="[paginate: 'purchases']" />
                                            <g:sortableColumn action="show"  property="invoiceNumber"
                                                                                title="Invoice Number" params="[paginate: 'purchases']" />
                                            <g:sortableColumn action="show"  property="inventoryItemPurchaseType"
                                                                                title="Type" params="[paginate: 'purchases']" />
                                            <th>
                                                <img  src="${resource(dir:'images/skin',file:'database_go_grey.png')}" alt="Show" title="Show" />
                                            </th>
                                            <th>
                                                <img  src="${resource(dir:'images/skin',file:'basket_put_grey.png')}" alt="Receive" title="Receive" />
                                            </th>
                                            <th>
                                                <img  src="${resource(dir:'images/skin',file:'tick_grey.png')}" alt="Approve" title="Approve Payment" />
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${inventoryItemPurchases}" status="i" var="purchase">
                                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'purchaseOrderNumber')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    <g:formatDate date="${purchase.dateEntered}" format="EEE, dd-MMM-yyyy"/>
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'costCode')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'quantity')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'orderValueAmount')}
                                                    ${fieldValue(bean:purchase, field:'orderValueCurrency')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'invoiceNumber')}
                                                </td>
                                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}"'>
                                                    ${fieldValue(bean:purchase, field:'inventoryItemPurchaseType')}
                                                </td>
                                                <td class="notClickable">
                                                    <g:link controller="inventoryItemPurchaseDetailed" action="show" id="${purchase.id}">
                                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                                    </g:link>
                                                </td>
                                                <g:if test="${purchase.inventoryItemPurchaseType.id == 1}">
                                                    <g:if test="${!purchase.receivedComplete}">
                                                        <td class="notClickable">
                                                            <g:link controller="inventoryItemPurchaseDetailed" action="receive" id="${purchase.id}">
                                                                <img  src="${resource(dir:'images/skin',file:'basket_put.png')}" alt="Receive" title="Receive" />
                                                            </g:link>
                                                        </td>
                                                    </g:if>
                                                    <g:else>
                                                        <td class="notClickable">
                                                        </td>
                                                    </g:else>
                                                    <g:if test="${!purchase.invoicePaymentApproved}">
                                                        <td class="notClickable">
                                                            <g:link controller="inventoryItemPurchaseDetailed" action="approveInvoicePayment" id="${purchase.id}">
                                                                <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Approve" title="Approve Payment" />
                                                            </g:link>
                                                        </td>
                                                    </g:if>
                                                    <g:else>
                                                        <td class="notClickable">
                                                        </td>
                                                    </g:else>
                                                </g:if>
                                                <g:else>
                                                    <td class="notClickable">
                                                    </td>
                                                    <td class="notClickable">
                                                    </td>
                                                </g:else>

                                            </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>

                            <div class="buttons">
                                <g:form controller="inventoryItemPurchaseDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    Results: ${inventoryItemPurchases.size()} / ${inventoryItemPurchasesTotal}
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Order" /></span>
                                </g:form>
                            </div>

                            <div class="paginateButtons">
                                <g:paginate action="show"
                                                        id="${inventoryItemInstance?.id}"
                                                        total="${inventoryItemPurchasesTotal}"
                                                        params="[paginate: 'purchases']" />
                            </div>

                        </g:else>

                    </richui:tabContent>
<!-- End Movement tab -->

                </richui:tabContents>
            </richui:tabView>

        </div>
    </body>
</html>
