/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.security.util.SimpleMethodInvocation;
import org.springframework.util.Assert;

public final class MethodInvocationUtils {
    private MethodInvocationUtils() {
    }

    public static MethodInvocation create(Object object, String methodName) {
        return MethodInvocationUtils.create(object, methodName, null);
    }

    public static MethodInvocation create(Object object, String methodName, Object[] args) {
        Advised a;
        Assert.notNull((Object)object, (String)"Object required");
        Class[] classArgs = null;
        if (args != null) {
            ArrayList list = new ArrayList();
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i].getClass());
            }
            classArgs = list.toArray(new Class[0]);
        }
        Class target = AopUtils.getTargetClass((Object)object);
        if (object instanceof Advised && !(a = (Advised)object).isProxyTargetClass()) {
            Class[] possibleInterfaces = a.getProxiedInterfaces();
            for (int i = 0; i < possibleInterfaces.length; ++i) {
                try {
                    possibleInterfaces[i].getMethod(methodName, classArgs);
                    target = possibleInterfaces[i];
                    break;
                }
                catch (Exception tryTheNextOne) {
                    continue;
                }
            }
        }
        return MethodInvocationUtils.createFromClass(object, target, methodName, classArgs, args);
    }

    public static MethodInvocation createFromClass(Class clazz, String methodName) {
        return MethodInvocationUtils.createFromClass(null, clazz, methodName, null, null);
    }

    public static MethodInvocation createFromClass(Object targetObject, Class clazz, String methodName, Class[] classArgs, Object[] args) {
        Method method;
        Assert.notNull((Object)clazz, (String)"Class required");
        Assert.hasText((String)methodName, (String)"MethodName required");
        try {
            method = clazz.getMethod(methodName, classArgs);
        }
        catch (Exception e) {
            return null;
        }
        return new SimpleMethodInvocation(targetObject, method, args);
    }
}

