import org.codehaus.groovy.grails.plugins.springsecurity.Secured
import org.codehaus.groovy.grails.commons.ConfigurationHolder
import org.springframework.web.servlet.support.RequestContextUtils as RCU

class ReportController extends BaseController {

    def authService
    def dateUtilService
    def taskReportService

    def index = { redirect(action:templatePortrait,params:params) }

    // the delete, save and update actions only accept POST requests
    //static allowedMethods = [list:'POST']

    def templatePortrait = {

        params.startDate = new Date()
        params.endDate = new Date()

        params.reportTitle = "Template Report (Portrait)"
        params.logoUrl = grailsApplication.mainContext.getResource('images/logo.png').getURL()
        params.currentUser = authService.currentUser
        params.startDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.startDate)
        params.endDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.endDate)

        def dataModel = createTemplateData()

        // Jasper plugin controller expects data to be a Collection.
        chain(controller:'jasper', action:'index', model:[data: [dataModel]], params:params)

    } // templatePortrait

    def templateLandscape = {

        params.startDate = new Date()
        params.endDate = new Date()

        params.reportTitle = "Template Report (Landscape)"
        params.logoUrl = grailsApplication.mainContext.getResource('images/logo.png').getURL()
        params.currentUser = authService.currentUser
        params.startDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.startDate)
        params.endDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.endDate)

        def dataModel = createTemplateData()

        // Jasper plugin controller expects data to be a Collection.
        chain(controller:'jasper', action:'index', model:[data: [dataModel]], params:params)

    } // templateLandscape

    private createTemplateData() {

        def result = [:]
        result.summaryOfCalculationMethod = "Summary string of the calculations performed."
        result.dataList = []
        for(i in 1..5) {
            def dataDetails = [:]
            dataDetails.description = "Data description " + i.toString()
            result.dataList << dataDetails
        }

        // Success.
        return result

    } // createTemplateData

    def downloadTemplate = {

        // params.fileName is not used directly to negate any security issues..
        def fileName = (params.fileName == 'templateLandscape.jrxml') ? 'templateLandscape.jrxml' : 'templatePortrait.jrxml'
        def f = grailsApplication.mainContext.getResource("reports/${fileName}").getFile()
        if(f.isFile()) {
            response.contentType = ConfigurationHolder.config.grails.mime.types["text"]
            response.setHeader("Content-disposition", "attachment; filename=${fileName}")
            render f.text
        }
        else
            render(status:404, text: "File Not Found: ${f}")

    } // downLoadTemplate

    def reactiveRatio = {

        params.reportTitle = "Reactive Ratio Report"
        params.logoUrl = grailsApplication.mainContext.getResource('images/logo.png').getURL()
        params.currentUser = authService.currentUser
        params.startDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.startDate)
        params.endDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.endDate)

        def dataModel = taskReportService.getReactiveRatio(params, RCU.getLocale(request))

        // Jasper plugin controller expects data to be a Collection.
        chain(controller:'jasper', action:'index', model:[data: [dataModel]], params:params)

    } // reactiveRatio

    def immediateCallouts = {

        params.reportTitle = "Immediate Callouts"
        params.logoUrl = grailsApplication.mainContext.getResource('images/logo.png').getURL()
        params.currentUser = authService.currentUser
        params.startDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.startDate)
        params.endDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.endDate)

        def dataModel = taskReportService.getImmediateCallouts(params, RCU.getLocale(request))

        // Jasper plugin controller expects data to be a Collection.
        chain(controller:'jasper', action:'index', model:[data: [dataModel]], params:params)

    } // immediateCallouts

} // end of class.
