import org.codehaus.groovy.grails.plugins.springsecurity.Secured
import org.springframework.web.servlet.support.RequestContextUtils as RCU

class ReportController extends BaseController {

    def authService
    def dateUtilService
    def taskReportService

    def index = { redirect(action:templatePortrait,params:params) }

    // the delete, save and update actions only accept POST requests
    //static allowedMethods = [list:'POST']

    def templatePortrait = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        params.reportTitle = "Template Report (Portrait)"
        params.currentUser = authService.currentUser
        def dataModel = createTemplateData()

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    def templateLandscape = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        params.reportTitle = "Template Report (Landscape)"
        params.currentUser = authService.currentUser
        def dataModel = createTemplateData()

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    private createTemplateData() {
        def dataModel = []
        for(i in 1..5) {
            def data = [:]
            data.description = "Data description " + i.toString()
            dataModel.add(data)
        }
        return dataModel
    }

    def reactiveRatio = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        params.reportTitle = "Reactive Ratio Report"
        params.currentUser = authService.currentUser
        params.startDate = dateUtilService.yesterday-14
        params.endDate = dateUtilService.tomorrow+15
        def dataModel = [taskReportService.getReactiveRatio(params, RCU.getLocale(request))]

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    def test = {
        render taskReportService.getReactiveRatio(params, RCU.getLocale(request))
    }

} // end of class.
