import grails.test.*

/**
* Integration tests for CreateDataService.
*/
class CreateDataServiceTests extends GroovyTestCase {

    def appConfigService
    def createDataService

    // Setup is called before each test and any data saved is discarded after each test.
    protected void setUp() {
        super.setUp()
    }

    protected void tearDown() {
        super.tearDown()
    }

    void testBaseDataCreated() {

        // Base data should have been created during bootstrap.
        assertTrue appConfigService.exists("baseDataCreated")

        // Some base data has indeed been created.
        assert PersonGroupType.count() > 0

    } // testBaseDataCreated()

    void testCreateBaseData() {

        // Base data has already been created in bootstrap,
        // therefore simply running this will create a host of unique constraint errors
        // if the method does not exit at the correct point and return false.
        assertFalse createDataService.createBaseData()

    } // testCreateBaseData()

    void testCreateDemoData() {

        def taskCount

        // No demo tasks yet.
        taskCount = Task.count()
        assert taskCount == 0

        // Base data has already been created in bootstrap so
        // demo data creation should go forward.
        assertTrue createDataService.createDemoData()

        // Should now have some demo tasks.
        taskCount = Task.count()
        assert taskCount > 0

        // Returns false since demo data has already been created.
        assertFalse createDataService.createDemoData()

        // Task count should not have changed.
        assert Task.count() == taskCount

    } // testCreateDemoData()

    void testDemoDataCreationDisabled() {

        def taskCount

        // No demo tasks yet.
        taskCount = Task.count()
        assert taskCount == 0

        appConfigService.set("demoDataCreationDisabled")

        // False since demo data creation has disabled.
        assertFalse createDataService.createDemoData()

        // Still no demo tasks.
        taskCount = Task.count()
        assert taskCount == 0

    } // testDemoDataCreationDisabled()

    void testCreateDemoDataWithNoBaseData() {

        def taskCount

        // No demo tasks yet.
        taskCount = Task.count()
        assert taskCount == 0

        // Base data has already been created in bootstrap so
        // simulate base data not created.
        assertTrue appConfigService.delete("baseDataCreated")

        // Returns false since demo data creation has not been recorded.
        assertFalse createDataService.createDemoData()

        // Still no demo tasks.
        taskCount = Task.count()
        assert taskCount == 0

    } // testCreateDemoDataWithNoBaseData()

} // end class