import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class InventoryItemPurchaseDetailedController extends BaseController {

    def authService
    def inventoryPurchaseService

    def index = {
        redirect(controller: 'inventoryItemDetailed', action:'search', params:params)
    }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def show = {
        def inventoryItemPurchaseInstance = InventoryItemPurchase.read( params.id )

        if(!inventoryItemPurchaseInstance) {
            flash.message = "InventoryItemPurchase not found with id ${params.id}"
            redirect(controller: 'inventoryItemDetailed', action:'search')
        }
        else { return [ inventoryItemPurchaseInstance : inventoryItemPurchaseInstance ] }
    }

    def delete = {
        def result = inventoryPurchaseService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["InventoryItemPurchase", params.id])
            redirect(controller: 'inventoryItemDetailed',
                            action: 'show',
                            id: result.inventoryItemId,
                            params: [showTab: "showPurchasingTab"])
            return
        }

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller: 'inventoryItemDetailed', action: 'search')
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def result = inventoryPurchaseService.edit(params)

        if(!result.error)
            return [ inventoryItemPurchaseInstance : result.inventoryItemPurchaseInstance ]

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)
        redirect(controller: 'inventoryItemDetailed', action:'search', params:params)
    }

    def update = {
        def result = inventoryPurchaseService.update(params)

        if(!result.error) {
            flash.message = g.message(code: "default.update.success", args: ["Inventory Purchase", params.id])
            redirect(action:show, id: params.id)
            return
        }

        if(result.error.code == "default.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: 'inventoryItemDetailed', action:'search', params:params)
            return
        }

        render(view:'edit', model:[inventoryItemPurchaseInstance: result.inventoryItemPurchaseInstance.attach()])
    }

    def create = {
        def inventoryItemPurchaseInstance = new InventoryItemPurchase()
        inventoryItemPurchaseInstance.properties = params

        if(!inventoryItemPurchaseInstance.inventoryItem) {
            flash.message = "Please select an inventory item then the 'purchasing' tab."
            redirect(controller: 'inventoryItemDetailed', action: 'search')
            return
        }

        return ['inventoryItemPurchaseInstance':inventoryItemPurchaseInstance]
    }

    def save = {
        def result = inventoryPurchaseService.save(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["Inventory Purchase", ''])
            redirect(controller: 'inventoryItemDetailed',
                            action: 'show',
                            id: result.inventoryItemId,
                            params: [showTab: "showPurchasingTab"])
            return
        }

        render(view:'create', model:['inventoryItemPurchaseInstance': result.inventoryItemPurchaseInstance])
    }

    def receive = {
        def inventoryItemPurchaseInstance = InventoryItemPurchase.read( params.id )

        if(!inventoryItemPurchaseInstance) {
            flash.message = "InventoryItemPurchase not found with id ${params.id}"
            redirect(controller: 'inventoryItemDetailed', action:'search')
            return
        }

        inventoryItemPurchaseInstance.properties = params
        def calcQuantities = inventoryPurchaseService.calcQuantities(inventoryItemPurchaseInstance)
        inventoryItemPurchaseInstance.quantity = calcQuantities.thisOrderRemaining
        return ['inventoryItemPurchaseInstance':inventoryItemPurchaseInstance,
                        'orderId': inventoryItemPurchaseInstance.id]
    }

    def receiveSave = {
        def result = inventoryPurchaseService.receiveSave(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["Inventory Purchase", ''])
            redirect(controller: 'inventoryItemDetailed',
                            action: 'show',
                            id: result.inventoryItemId,
                            params: [showTab: "showPurchasingTab"])
            return
        }

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller: 'inventoryItemDetailed', action: 'search')
            return
        }

        render(view:'receive',
                        model:['inventoryItemPurchaseInstance': result.inventoryItemPurchaseInstance,
                                    'orderId': result.orderId])
    }

    def approveInvoicePayment = {
        def inventoryItemPurchaseInstance = InventoryItemPurchase.read( params.id )

        if(!inventoryItemPurchaseInstance) {
            flash.message = "InventoryItemPurchase not found with id ${params.id}"
            redirect(controller: 'inventoryItemDetailed', action:'search')
            return
        }

        inventoryItemPurchaseInstance.properties = params
        return ['inventoryItemPurchaseInstance':inventoryItemPurchaseInstance,
                        'orderId': inventoryItemPurchaseInstance.id]
    }

    def approveInvoicePaymentSave = {
        def result = inventoryPurchaseService.approveInvoicePaymentSave(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["Inventory Purchase", ''])
            redirect(controller: 'inventoryItemDetailed',
                            action: 'show',
                            id: result.inventoryItemId,
                            params: [showTab: "showPurchasingTab"])
            return
        }

        if(result.error.code == "default.not.found") {
            flash.errorMessage = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: 'inventoryItemDetailed', action: 'search')
            return
        }

        render(view:'approveInvoicePayment',
                    model:['inventoryItemPurchaseInstance': result.inventoryItemPurchaseInstance,
                                    'orderId': result.orderId])
    }
}
