import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_Manager','ROLE_AppAdmin'])
class MaintenancePolicyDetailedController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ maintenancePolicyInstanceList: MaintenancePolicy.list( params ), maintenancePolicyInstanceTotal: MaintenancePolicy.count() ]
    }

    def show = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )

        if(!maintenancePolicyInstance) {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ maintenancePolicyInstance : maintenancePolicyInstance ] }
    }

    def delete = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )
        if(maintenancePolicyInstance) {
            try {
                maintenancePolicyInstance.delete(flush:true)
                flash.message = "MaintenancePolicy ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "MaintenancePolicy ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )

        if(!maintenancePolicyInstance) {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ maintenancePolicyInstance : maintenancePolicyInstance ]
        }
    }

    def update = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )
        if(maintenancePolicyInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(maintenancePolicyInstance.version > version) {
                    
                    maintenancePolicyInstance.errors.rejectValue("version", "maintenancePolicy.optimistic.locking.failure", "Another user has updated this MaintenancePolicy while you were editing.")
                    render(view:'edit',model:[maintenancePolicyInstance:maintenancePolicyInstance])
                    return
                }
            }
            maintenancePolicyInstance.properties = params
            if(!maintenancePolicyInstance.hasErrors() && maintenancePolicyInstance.save(flush: true)) {
                flash.message = "MaintenancePolicy ${params.id} updated"
                redirect(action:show,id:maintenancePolicyInstance.id)
            }
            else {
                render(view:'edit',model:[maintenancePolicyInstance:maintenancePolicyInstance])
            }
        }
        else {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def maintenancePolicyInstance = new MaintenancePolicy()
        maintenancePolicyInstance.properties = params
        return ['maintenancePolicyInstance':maintenancePolicyInstance]
    }

    def save = {
        def maintenancePolicyInstance = new MaintenancePolicy(params)
        if(!maintenancePolicyInstance.hasErrors() && maintenancePolicyInstance.save(flush: true)) {
            flash.message = "MaintenancePolicy ${maintenancePolicyInstance.id} created"
            redirect(action:show,id:maintenancePolicyInstance.id)
        }
        else {
            render(view:'create',model:[maintenancePolicyInstance:maintenancePolicyInstance])
        }
    }
}
