class Person {
    String firstName
    String lastName
    Integer employeeID
    boolean isActive = true

    static hasMany = [modifications : Modification,
                        entries : Entry,
                        tasks : Task,
                        personGroups : PersonGroup]

    static belongsTo = [PersonGroup]

    static optionals = ["employeeID"]

    static constraints = {
        firstName(maxSize:50,blank:false)
        lastName(maxSize:50,blank:false)
        employeeID(blank:true, nullable:true)
    }

    //Overriding the default toString method
    String toString() {"${this.firstName} ${this.lastName}"}
}
