

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create AssetSubItem</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="search">Sub Item Search</g:link></span>
        </div>
        <div class="body">
            <h1>Create Sub Item</h1>
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${assetSubItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetSubItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>

                            <g:if test="${assetSubItemInstance?.parentItem}" >
                                <g:hiddenField name="parentItem.id" value="${assetSubItemInstance.parentItem.id}" />
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="parentItem">Parent Item:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        ${assetSubItemInstance.parentItem.encodeAsHTML()}
                                    </td>
                                </tr>
                            </g:if>

                            <g:if test="${assetInstance}" >
                                <g:hiddenField name="asset.id" value="${assetInstance.id}" />
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="asset">Link with Asset:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        ${assetInstance.encodeAsHTML()}
                                    </td>
                                </tr>
                            </g:if>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:assetSubItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:assetSubItemInstance,field:'description')}"/>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetSubItemInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:assetSubItemInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
