

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Asset</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assetInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetInstance?.id}" />
                <input type="hidden" name="version" value="${assetInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:assetInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="100" id="description" name="description" value="${fieldValue(bean:assetInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:assetInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="section">Section:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'section','errors')}">
                                    <g:select optionKey="id" from="${Section.list()}" name="section.id" value="${assetInstance?.section?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetExtendedAttributes">Asset Extended Attributes:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetExtendedAttributes','errors')}">
                                    
<ul>
<g:each var="a" in="${assetInstance?.assetExtendedAttributes?}">
    <li><g:link controller="assetExtendedAttributeDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="assetExtendedAttributeDetailed" params="['asset.id':assetInstance?.id]" action="create">Add AssetExtendedAttribute</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetSubItems">Asset Sub Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetSubItems','errors')}">
                                    <custom:checkBoxList name="assetSubItems"
                                                                    from="${AssetSubItem.list()}"
                                                                    value="${assetInstance?.assetSubItems.collect{it.id}}"
                                                                    optionKey="id"
                                                                    displayFields="['id', 'name']"
                                                                    linkController="assetSubItemDetailed"
                                                                    linkAction="show"/>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${assetInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceActionDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceActionDetailed" params="['asset.id':assetInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
