import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_Manager','ROLE_AppAdmin'])
class SectionDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ sectionInstanceList: Section.list( params ), sectionInstanceTotal: Section.count() ]
    }

    def show = {
        def sectionInstance = Section.get( params.id )

        if(!sectionInstance) {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ sectionInstance : sectionInstance ] }
    }

    def delete = {
        def sectionInstance = Section.get( params.id )
        if(sectionInstance) {
            try {
                sectionInstance.delete(flush:true)
                flash.message = "Section ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Section ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def sectionInstance = Section.get( params.id )

        if(!sectionInstance) {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ sectionInstance : sectionInstance ]
        }
    }

    def update = {
        def sectionInstance = Section.get( params.id )
        if(sectionInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(sectionInstance.version > version) {
                    
                    sectionInstance.errors.rejectValue("version", "section.optimistic.locking.failure", "Another user has updated this Section while you were editing.")
                    render(view:'edit',model:[sectionInstance:sectionInstance])
                    return
                }
            }
            sectionInstance.properties = params
            if(!sectionInstance.hasErrors() && sectionInstance.save(flush: true)) {
                flash.message = "Section ${params.id} updated"
                redirect(action:show,id:sectionInstance.id)
            }
            else {
                render(view:'edit',model:[sectionInstance:sectionInstance])
            }
        }
        else {
            flash.message = "Section not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def sectionInstance = new Section()
        sectionInstance.properties = params
        return ['sectionInstance':sectionInstance]
    }

    def save = {
        def sectionInstance = new Section(params)
        if(!sectionInstance.hasErrors() && sectionInstance.save(flush: true)) {
            flash.message = "Section ${sectionInstance.id} created"
            redirect(action:show,id:sectionInstance.id)
        }
        else {
            render(view:'create',model:[sectionInstance:sectionInstance])
        }
    }
}
