import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_Manager','ROLE_AppAdmin'])
class DepartmentExtendedAttributeDetailedController extends BaseController {

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ departmentExtendedAttributeInstanceList: DepartmentExtendedAttribute.list( params ), departmentExtendedAttributeInstanceTotal: DepartmentExtendedAttribute.count() ]
    }

    def show = {
        def departmentExtendedAttributeInstance = DepartmentExtendedAttribute.get( params.id )

        if(!departmentExtendedAttributeInstance) {
            flash.message = "DepartmentExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ departmentExtendedAttributeInstance : departmentExtendedAttributeInstance ] }
    }

    def delete = {
        def departmentExtendedAttributeInstance = DepartmentExtendedAttribute.get( params.id )
        if(departmentExtendedAttributeInstance) {
            try {
                departmentExtendedAttributeInstance.delete(flush:true)
                flash.message = "DepartmentExtendedAttribute ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "DepartmentExtendedAttribute ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "DepartmentExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def departmentExtendedAttributeInstance = DepartmentExtendedAttribute.get( params.id )

        if(!departmentExtendedAttributeInstance) {
            flash.message = "DepartmentExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ departmentExtendedAttributeInstance : departmentExtendedAttributeInstance ]
        }
    }

    def update = {
        def departmentExtendedAttributeInstance = DepartmentExtendedAttribute.get( params.id )
        if(departmentExtendedAttributeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(departmentExtendedAttributeInstance.version > version) {
                    
                    departmentExtendedAttributeInstance.errors.rejectValue("version", "departmentExtendedAttribute.optimistic.locking.failure", "Another user has updated this DepartmentExtendedAttribute while you were editing.")
                    render(view:'edit',model:[departmentExtendedAttributeInstance:departmentExtendedAttributeInstance])
                    return
                }
            }
            departmentExtendedAttributeInstance.properties = params
            if(!departmentExtendedAttributeInstance.hasErrors() && departmentExtendedAttributeInstance.save(flush: true)) {
                flash.message = "DepartmentExtendedAttribute ${params.id} updated"
                redirect(action:show,id:departmentExtendedAttributeInstance.id)
            }
            else {
                render(view:'edit',model:[departmentExtendedAttributeInstance:departmentExtendedAttributeInstance])
            }
        }
        else {
            flash.message = "DepartmentExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def departmentExtendedAttributeInstance = new DepartmentExtendedAttribute()
        departmentExtendedAttributeInstance.properties = params
        return ['departmentExtendedAttributeInstance':departmentExtendedAttributeInstance]
    }

    def save = {
        def departmentExtendedAttributeInstance = new DepartmentExtendedAttribute(params)
        if(!departmentExtendedAttributeInstance.hasErrors() && departmentExtendedAttributeInstance.save(flush: true)) {
            flash.message = "DepartmentExtendedAttribute ${departmentExtendedAttributeInstance.id} created"
            redirect(action:show,id:departmentExtendedAttributeInstance.id)
        }
        else {
            render(view:'create',model:[departmentExtendedAttributeInstance:departmentExtendedAttributeInstance])
        }
    }
}
