import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_Manager','ROLE_AppAdmin'])
class SiteExtendedAttributeDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ siteExtendedAttributeInstanceList: SiteExtendedAttribute.list( params ), siteExtendedAttributeInstanceTotal: SiteExtendedAttribute.count() ]
    }

    def show = {
        def siteExtendedAttributeInstance = SiteExtendedAttribute.get( params.id )

        if(!siteExtendedAttributeInstance) {
            flash.message = "SiteExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ siteExtendedAttributeInstance : siteExtendedAttributeInstance ] }
    }

    def delete = {
        def siteExtendedAttributeInstance = SiteExtendedAttribute.get( params.id )
        if(siteExtendedAttributeInstance) {
            try {
                siteExtendedAttributeInstance.delete(flush:true)
                flash.message = "SiteExtendedAttribute ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "SiteExtendedAttribute ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "SiteExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def siteExtendedAttributeInstance = SiteExtendedAttribute.get( params.id )

        if(!siteExtendedAttributeInstance) {
            flash.message = "SiteExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ siteExtendedAttributeInstance : siteExtendedAttributeInstance ]
        }
    }

    def update = {
        def siteExtendedAttributeInstance = SiteExtendedAttribute.get( params.id )
        if(siteExtendedAttributeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(siteExtendedAttributeInstance.version > version) {
                    
                    siteExtendedAttributeInstance.errors.rejectValue("version", "siteExtendedAttribute.optimistic.locking.failure", "Another user has updated this SiteExtendedAttribute while you were editing.")
                    render(view:'edit',model:[siteExtendedAttributeInstance:siteExtendedAttributeInstance])
                    return
                }
            }
            siteExtendedAttributeInstance.properties = params
            if(!siteExtendedAttributeInstance.hasErrors() && siteExtendedAttributeInstance.save(flush: true)) {
                flash.message = "SiteExtendedAttribute ${params.id} updated"
                redirect(action:show,id:siteExtendedAttributeInstance.id)
            }
            else {
                render(view:'edit',model:[siteExtendedAttributeInstance:siteExtendedAttributeInstance])
            }
        }
        else {
            flash.message = "SiteExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def siteExtendedAttributeInstance = new SiteExtendedAttribute()
        siteExtendedAttributeInstance.properties = params
        return ['siteExtendedAttributeInstance':siteExtendedAttributeInstance]
    }

    def save = {
        def siteExtendedAttributeInstance = new SiteExtendedAttribute(params)
        if(!siteExtendedAttributeInstance.hasErrors() && siteExtendedAttributeInstance.save(flush: true)) {
            flash.message = "SiteExtendedAttribute ${siteExtendedAttributeInstance.id} created"
            redirect(action:show,id:siteExtendedAttributeInstance.id)
        }
        else {
            render(view:'create',model:[siteExtendedAttributeInstance:siteExtendedAttributeInstance])
        }
    }
}
