import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetSubItemController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assetSubItemInstanceList: AssetSubItem.list( params ), assetSubItemInstanceTotal: AssetSubItem.count() ]
    }

    def show = {
        def assetSubItemInstance = AssetSubItem.get( params.id )

        if(!assetSubItemInstance) {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assetSubItemInstance : assetSubItemInstance ] }
    }

    def delete = {
        def assetSubItemInstance = AssetSubItem.get( params.id )
        if(assetSubItemInstance) {
            try {
                assetSubItemInstance.delete(flush:true)
                flash.message = "AssetSubItem ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetSubItem ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assetSubItemInstance = AssetSubItem.get( params.id )

        if(!assetSubItemInstance) {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assetSubItemInstance : assetSubItemInstance ]
        }
    }

    def update = {
        def assetSubItemInstance = AssetSubItem.get( params.id )
        if(assetSubItemInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetSubItemInstance.version > version) {
                    
                    assetSubItemInstance.errors.rejectValue("version", "assetSubItem.optimistic.locking.failure", "Another user has updated this AssetSubItem while you were editing.")
                    render(view:'edit',model:[assetSubItemInstance:assetSubItemInstance])
                    return
                }
            }
            assetSubItemInstance.properties = params
            if(!assetSubItemInstance.hasErrors() && assetSubItemInstance.save(flush: true)) {
                flash.message = "AssetSubItem ${params.id} updated"
                redirect(action:show,id:assetSubItemInstance.id)
            }
            else {
                render(view:'edit',model:[assetSubItemInstance:assetSubItemInstance])
            }
        }
        else {
            flash.message = "AssetSubItem not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assetSubItemInstance = new AssetSubItem()
        assetSubItemInstance.properties = params
        return ['assetSubItemInstance':assetSubItemInstance]
    }

    def save = {
        def assetSubItemInstance = new AssetSubItem(params)
        if(!assetSubItemInstance.hasErrors() && assetSubItemInstance.save(flush: true)) {
            flash.message = "AssetSubItem ${assetSubItemInstance.id} created"
            redirect(action:show,id:assetSubItemInstance.id)
        }
        else {
            render(view:'create',model:[assetSubItemInstance:assetSubItemInstance])
        }
    }
}
