class AssignedPersonService {

    boolean transactional = false

    def personService

    def list(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson"] ]
            return result
        }

        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        result.assignedPersonInstanceList = AssignedPerson.list(params)
        result.assignedPersonInstanceTotal = AssignedPerson.count()

        if(!result.assignedPersonInstanceList || !result.assignedPersonInstanceTotal)
            return fail(code:"default.list.failure")

        // Success.
        return result
    }

    def show(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def delete(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.assignedPersonInstance = AssignedPerson.get(params.id)

            if(!result.assignedPersonInstance)
                return fail(code:"default.not.found")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(11),
                                                    task: result.assignedPersonInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            try {
                result.assignedPersonInstance.delete(flush:true)
                return result //Success.
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                return fail(code:"default.delete.failure")
            }

        } //end withTransaction
    } // end delete()

    def edit(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def update(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.assignedPersonInstance = AssignedPerson.get(params.id)

            if(!result.assignedPersonInstance)
                return fail(code:"default.not.found")

            // Optimistic locking check.
            if(params.version) {
                if(result.assignedPersonInstance.version > params.version.toLong())
                    return fail(field:"version", code:"default.optimistic.locking.failure")
            }

            result.assignedPersonInstance.properties = params

            if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save())
                return fail(code:"default.update.failure")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(11),
                                                    task: result.assignedPersonInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            // Success.
            return result

        } //end withTransaction
    }  // end update()

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        if(!params.task?.id)
            fail(code:"assignedPerson.task.not.found")

        result.assignedPersonInstance = new AssignedPerson()
        result.assignedPersonInstance.properties = params

        // success
        return result
    }

    def save(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.assignedPersonInstance = new AssignedPerson(params)

            if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save())
                return fail(code:"default.create.failure")

            // Record a taskModification for every one except "system".
            if(personService.currentUser.id != 1) {
                def taskModification = new TaskModification(person: personService.currentUser,
                                                        taskModificationType: TaskModificationType.get(11),
                                                        task: result.assignedPersonInstance.task)

                if(!taskModification.save())
                    return fail(field:"taskModifications", code:"task.modifications.failedToSave")
            }

            // success
            return result

        } //end withTransaction
    } // end save()

} // end class