import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class SiteController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ siteInstanceList: Site.list( params ), siteInstanceTotal: Site.count() ]
    }

    def show = {
        def siteInstance = Site.get( params.id )

        if(!siteInstance) {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ siteInstance : siteInstance ] }
    }

    def delete = {
        def siteInstance = Site.get( params.id )
        if(siteInstance) {
            try {
                siteInstance.delete(flush:true)
                flash.message = "Site ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Site ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def siteInstance = Site.get( params.id )

        if(!siteInstance) {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ siteInstance : siteInstance ]
        }
    }

    def update = {
        def siteInstance = Site.get( params.id )
        if(siteInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(siteInstance.version > version) {
                    
                    siteInstance.errors.rejectValue("version", "site.optimistic.locking.failure", "Another user has updated this Site while you were editing.")
                    render(view:'edit',model:[siteInstance:siteInstance])
                    return
                }
            }
            siteInstance.properties = params
            if(!siteInstance.hasErrors() && siteInstance.save(flush: true)) {
                flash.message = "Site ${params.id} updated"
                redirect(action:show,id:siteInstance.id)
            }
            else {
                render(view:'edit',model:[siteInstance:siteInstance])
            }
        }
        else {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def siteInstance = new Site()
        siteInstance.properties = params
        return ['siteInstance':siteInstance]
    }

    def save = {
        def siteInstance = new Site(params)
        if(!siteInstance.hasErrors() && siteInstance.save(flush: true)) {
            flash.message = "Site ${siteInstance.id} created"
            redirect(action:show,id:siteInstance.id)
        }
        else {
            render(view:'create',model:[siteInstance:siteInstance])
        }
    }
}
