import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskModificationTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskModificationTypeInstanceList: TaskModificationType.list( params ), taskModificationTypeInstanceTotal: TaskModificationType.count() ]
    }

    def show = {
        def taskModificationTypeInstance = TaskModificationType.get( params.id )

        if(!taskModificationTypeInstance) {
            flash.message = "TaskModificationType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskModificationTypeInstance : taskModificationTypeInstance ] }
    }

    def delete = {
        def taskModificationTypeInstance = TaskModificationType.get( params.id )
        if(taskModificationTypeInstance) {
            try {
                taskModificationTypeInstance.delete(flush:true)
                flash.message = "TaskModificationType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskModificationType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskModificationType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskModificationTypeInstance = TaskModificationType.get( params.id )

        if(!taskModificationTypeInstance) {
            flash.message = "TaskModificationType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskModificationTypeInstance : taskModificationTypeInstance ]
        }
    }

    def update = {
        def taskModificationTypeInstance = TaskModificationType.get( params.id )
        if(taskModificationTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskModificationTypeInstance.version > version) {
                    
                    taskModificationTypeInstance.errors.rejectValue("version", "taskModificationType.optimistic.locking.failure", "Another user has updated this TaskModificationType while you were editing.")
                    render(view:'edit',model:[taskModificationTypeInstance:taskModificationTypeInstance])
                    return
                }
            }
            taskModificationTypeInstance.properties = params
            if(!taskModificationTypeInstance.hasErrors() && taskModificationTypeInstance.save(flush: true)) {
                flash.message = "TaskModificationType ${params.id} updated"
                redirect(action:show,id:taskModificationTypeInstance.id)
            }
            else {
                render(view:'edit',model:[taskModificationTypeInstance:taskModificationTypeInstance])
            }
        }
        else {
            flash.message = "TaskModificationType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskModificationTypeInstance = new TaskModificationType()
        taskModificationTypeInstance.properties = params
        return ['taskModificationTypeInstance':taskModificationTypeInstance]
    }

    def save = {
        def taskModificationTypeInstance = new TaskModificationType(params)
        if(!taskModificationTypeInstance.hasErrors() && taskModificationTypeInstance.save(flush: true)) {
            flash.message = "TaskModificationType ${taskModificationTypeInstance.id} created"
            redirect(action:show,id:taskModificationTypeInstance.id)
        }
        else {
            render(view:'create',model:[taskModificationTypeInstance:taskModificationTypeInstance])
        }
    }
}
