<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task</title>
        <resource:tabView skin="tabviewCustom" />
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Task List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Task</g:link></span>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskProcedureInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskProcedureInstance}" as="list" />
            </div>
            </g:hasErrors>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTaskTab}" title="Task #${taskInstance.id}" />
                    <richui:tabLabel selected="${showProcedureTab}" title="Procedure" />
                    <richui:tabLabel selected="${showRecurrenceTab}" title="Recurrence" />
                    <richui:tabLabel selected="${showInventoryTab}" title="Inventory" />
                    <richui:tabLabel selected="${showSubTasksTab}" title="Sub Tasks" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Start Task tab -->
                    <richui:tabContent>
            
                        <div class="dialog">
                            <table>
                                <tbody>
            
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Id:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'id')}</td>
                                        
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">Description:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'description')}</td>
                                        
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">Comment:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Target Start Date:</td>
                                        
                                        <td valign="top" class="value"><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd MMM yyyy"/></td>
                                        
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">Target Completion Date:</td>
                                        
                                        <td valign="top" class="value"><g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd MMM yyyy"/></td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Lead Person:</td>
                                        
                                        <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Task Priority:</td>
                                        
                                        <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Task Status:</td>
                                        
                                        <td valign="top" class="value">${taskInstance?.taskStatus?.encodeAsHTML()}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Is Active:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isActive')}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Is Approved:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isApproved')}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Is Scheduled:</td>
                                        
                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isScheduled')}</td>
                                        
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">Parent Task:</td>
                                        
                                        <td valign="top" class="value"><g:link controller="taskDetailed" action="show" id="${taskInstance?.parentTask?.id}">${taskInstance?.parentTask?.encodeAsHTML()}</g:link></td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Task Group:</td>
                                        
                                        <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>
                                        
                                    </tr>
                                
                                    <tr class="prop">
                                        <td valign="top" class="name">Task Type:</td>
                                        
                                        <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>
                                        
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">Assigned Persons:</td>
                                        
                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${taskInstance.assignedPersons}">
                                                <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                            <g:link controller="assignedPersonDetailed" params="['task.id':taskInstance?.id]" action="create">Add AssignedPerson</g:link>
                                        </td>
                                        
                                    </tr>
                                
                                </tbody>
                            </table>
                        </div>
            
                        <div class="buttons">
                            <g:form>
                                <input type="hidden" name="id" value="${taskInstance?.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>
            
                        <div class="list">
                            <h1>Faults</h1>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Comment</th>
                                        <th>Date Done</th>
                                        <th>Duration</th>
                                        <th>Entered By</th>
                                        <th></th>
            
            <!--                            <g:sortableColumn property="comment" title="Comment" />
                                    
                                        <g:sortableColumn property="dateDone" title="Date Done" />
                                    
                                        <g:sortableColumn property="enteredBy" title="Entered By" />-->
                                    </tr>
                                </thead>
                                <tbody>
                                <g:each in="${entryFaultList}" status="i" var="entry">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>
                                        
                                            <td style="width:65%">${entry.comment}</td>
                                            <td><g:formatDate date="${entry.dateDone}" format="EEE, dd MMM yyyy"/></td>
                                            <td>${entry.durationHour}:${entry.durationMinute}</td>
                                            <td>${entry.enteredBy}</td>
            
                                            <td>
                                                <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                    <img  src="${createLinkTo(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                                </g:link>
                                            </td>
            
                                        </tr>
                                </g:each>
                                </tbody>
                            </table>
                        </div>
            
                        <div class="list">
                            <h1>Work Done</h1>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Comment</th>
                                        <th>Date Done</th>
                                        <th>Duration</th>
                                        <th>Entered By</th>
                                        <th></th>
            
            <!--                            <g:sortableColumn property="commentW" title="Comment" />
                                    
                                        <g:sortableColumn property="dateDoneW" title="Date Done" />
                                    
                                        <g:sortableColumn property="enteredByW" title="Entered By" />-->
                                    </tr>
                                </thead>
                                <tbody>
                                <g:each in="${entryWorkDoneList}" status="i" var="entry">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>
            
                                            <td width="65%">${entry.comment}</td>
                                            <td><g:formatDate date="${entry.dateDone}" format="EEE, dd MMM yyyy"/></td>
                                            <td>${entry.durationHour}:${entry.durationMinute}</td>
                                            <td>${entry.enteredBy}</td>
            
                                            <td>
                                                <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                    <img  src="${createLinkTo(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                                </g:link>
                                            </td>
            
                                        </tr>
                                </g:each>
                                </tbody>
                            </table>
                        </div>
            
                        <br />
            
                        <div class="buttons">
                            <g:form controller="entryDetailed">
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />
                                <span class="button">
                                    <g:actionSubmit value="Add Entry" action="create"  class="add"/>
                                </span>
                            </g:form>
                        </div>
                    </richui:tabContent>
<!-- End Task tab -->



<!-- Start Task Procedure tab-->
                    <richui:tabContent>
                        <g:if test="${!taskProcedureExits}">
                        	<br />
                        	No Procedure linked.
                        	<br />
							<br />
                            <g:form controller="taskProcedureDetailed" >
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="New" action="create"  class="add"/>
                                    </span>
                                    <span class="button">
                                        <g:actionSubmit value="Search" action="search"  class="search"/>
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>
                        	<div class="dialog">
                                <table>
                                    <tbody>
                
                                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Procedure Id:</td>
                                            
                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'id')}</td>
                                            
                                        </tr>
                                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Name:</td>
                                            
                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'name')}</td>
                                            
                                        </tr>
                                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Description:</td>
                                            
                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'description')}</td>
                                            
                                        </tr>
                                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Is Active:</td>
                                            
                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'isActive')}</td>
                                            
                                        </tr>
                                    
                                    </tbody>
                                </table>
                            </div>
                            <div class="buttons">
                                <g:form controller="taskProcedureDetailed">
                                    <input type="hidden" name="id" value="${taskProcedureInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
								</g:form>
                            </div>
                            
							<div class="list">
								<table>
									<thead>
										<tr>
											<th>Step</th>
											<th>Description</th>
										</tr>
									</thead>
									<tbody>
										<g:each in="${maintenanceActionList}" status="i" var="maintenanceAction">
											<tr class="${(i % 2) == 0 ? 'odd' : 'even'}">
												
												<td valign="top" class="name">
													${maintenanceAction?.procedureStepNumber}
												</td>
												
												<td  valign="top" style="text-align:left;" class="value">
													${maintenanceAction?.description}
												</td>
												
											</tr>
										</g:each>
	
									</tbody>
								</table>
							</div>

                        </g:else>

                    </richui:tabContent>
<!-- End Task Procedure tab-->

<!-- Start Task Recurrence tab -->
                    <richui:tabContent>

                        <g:if test="${!taskRecurringScheduleExits}">
                        	<br />
                        	No Recurring Schedule.
                        	<br />
							<br />
                            <g:form controller="taskRecurringScheduleDetailed" >
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="Create" action="create"  class="add"/>
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>
							
						<div class="dialog">
								<table>
									<tbody>
										<tr class="prop">
											<td valign="top" class="name">Recurring Schedule:</td>
											
											<td valign="top" class="value">${taskRecurringScheduleInstance.encodeAsHTML()}</td>
											
										</tr>
				
										<tr class="prop">
											<td valign="top" class="name">Start Date:</td>
											
											<td valign="top" class="value">
												<g:formatDate date="${taskRecurringScheduleInstance.startDate}" format="EEE, dd MMM yyyy"/>
											</td>
                            
                                        </tr>
                                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Task Duration:</td>
                                            
                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.taskDuration} ${taskRecurringScheduleInstance?.taskDurationPeriod}
                                            </td>
                                        </tr>
                    
                                        <tr class="prop">
                                            <td valign="top" class="name">Generate Ahead:</td>
                                            
                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.generateAhead} ${taskRecurringScheduleInstance?.generateAheadPeriod}
                                            </td>
                                            
                                        </tr>
											
										</tr>
                    
										<tr class="prop">
											<td valign="top" class="name">Is Enabled:</td>
											
											<td valign="top" class="value">${fieldValue(bean:taskRecurringScheduleInstance, field:'isEnabled')}</td>
											
										</tr>
                                        
                                    </tbody>
                                </table>
                
                                <table>
                                    <tbody>
                        
										<tr class="prop">
											<td valign="top" class="name">Next Target Start Date:</td>   
											                         
											<td valign="top" class="value">
												<g:formatDate date="${taskRecurringScheduleInstance.nextTargetStartDate}" format="EEE, dd MMM yyyy"/>
											</td>
											
										</tr>
                
                                        <tr class="prop">
                                            <td valign="top" class="name">Next Target Completion Date:</td>   
                                                                     
                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetCompletionDate}" format="EEE, dd MMM yyyy"/>
                                            </td>
                                            
                                        </tr>
                        
                                        <tr class="prop">
                                            <td valign="top" class="name">Next Generation Date:</td>
                                            
                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextGenerationDate}" format="EEE, dd MMM yyyy"/>
                                            </td>
                                        </tr>
				
										<tr class="prop">
											<td valign="top" class="name">Last Generated Date:</td>
											                            
											<td valign="top" class="value">
												<g:formatDate date="${taskRecurringScheduleInstance.lastGeneratedDate}" format="EEE, dd MMM yyyy"/>
											</td>
											
										</tr>
				
										<tr class="prop">
											<td valign="top" class="name">Last Generated Sub Task:</td>
							                            
											<td valign="top" class="value">
												<g:link controller="taskDetailed" action="show" id="${taskRecurringScheduleInstance?.lastGeneratedSubTask?.id}">
													${taskRecurringScheduleInstance?.lastGeneratedSubTask?.encodeAsHTML()}
												</g:link>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
                            <div class="buttons">
                                <g:form controller="taskRecurringScheduleDetailed">
                                    <input type="hidden" name="id" value="${taskRecurringScheduleInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
								</g:form>
                            </div>
                            
						</g:else>
                    </richui:tabContent>
<!-- End Task Recurrence tab -->

<!-- Start Inventory tab -->
                    <richui:tabContent>
                        Used Inventory
                    </richui:tabContent>
<!-- End Inventory tab -->

<!-- Start Sub Task tab -->  
                    <richui:tabContent>
                    	<g:if test="${subTaskInstanceTotal >= 1}">
							<div class="list">
								<table>
									<thead>
										<tr>
										
											<th>Id</th>
											
											<th>Target Start Date</th>
											
											<th>Description</th>
											
											<th>Lead Person</th>
											
											<th>Task Priority</th>
										
											<th>Task Status</th>
											
											<th></th>
										
										</tr>
									</thead>
									<tbody>
									<g:each in="${subTaskInstanceList}" status="i" var="subTaskInstance">
									<tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'/>
	
											<td>${fieldValue(bean:subTaskInstance, field:'id')}</td>
											
											<td><g:formatDate date="${subTaskInstance.targetStartDate}" format="EEE, dd MMM yyyy"/></td>
											
											<td>${subTaskInstance.description}</td>
										
	
											<td>${subTaskInstance.leadPerson}</td>
											
											<td>${subTaskInstance.taskPriority}</td>
											
											<td>${subTaskInstance.taskStatus}</td>
											
											<td>
												<g:link action="show" id="${subTaskInstance.id}">
													<img  src="${createLinkTo(dir:'images/skin',file:'database_go.png')}" alt="Show" />
												</g:link>
											</td>
	
										
										</tr>
									</g:each>
									</tbody>
								</table>
							</div>
							
							
							<div class="buttons">
								<g:form>
									<input type="hidden" name="id" value="${taskInstance?.id}" />
									<g:if test="${subTaskInstanceTotal > subTaskInstanceMax}">
										Showing ${subTaskInstanceMax} of ${subTaskInstanceTotal}
										<br />
									</g:if>
									<g:else>
										Total ${subTaskInstanceTotal}
										<br />
									</g:else>
									<span class="button"><g:actionSubmit action="listSubTasks" class="table" value="Sortable List" /></span>
								</g:form>
							</div>
							
						</g:if>
						<g:else>
							<br />
							No Sub Tasks.
						</g:else>

                    </richui:tabContent>
<!-- End Sub Task tab -->

                </richui:tabContents>
            </richui:tabView>
            
        </div>
    </body>
</html>
