class Task {

    TaskGroup taskGroup
    TaskStatus taskStatus
    TaskPriority taskPriority
    TaskType taskType
    Task    parentTask
    Person leadPerson
    Asset primaryAsset
    RecurringSchedule recurringSchedule

    String description
    String comment = ""
    Date targetStartDate = new Date()
    Date targetCompletionDate = new Date()
    boolean isScheduled = false
    boolean isApproved = false
    boolean isActive = true

    static hasMany = [entries: Entry, 
                        taskModifications: TaskModification, 
                        assignedPersons: AssignedPerson, 
                        subTasks: Task,
                        associatedAssets: Asset,
                        inventoryMovements: InventoryMovement]

    static belongsTo = [TaskGroup, TaskStatus, Task, Person]

    static constraints = {
        targetStartDate()
        description(blank:false,maxSize:75)
        leadPerson()
        taskPriority()
        taskStatus()
        parentTask(blank: true, nullable:true)
        comment()
        primaryAsset(blank: true, nullable:true)
        recurringSchedule(blank: true, nullable:true)
        
    }

    String toString() {"${this.description}"}
}
