

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show TaskRecurringSchedule</title>
    </head>
    <body>
        <div class="nav">
            <h1>Show Recurring Schedule</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <div class="dialog">
                <table>
                    <tbody>
                        <tr class="prop">
                            <td valign="top" class="name">Recurring Schedule for task:</td>

                            <td valign="top" class="value">
                                <g:link controller="taskDetailed" action="show" id="${taskRecurringScheduleInstance.task?.id}">
                                    ${taskRecurringScheduleInstance.task.encodeAsHTML()}
                                </g:link>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"></td>

                            <td valign="top" class="value">${taskRecurringScheduleInstance.encodeAsHTML()}</td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Enabled:</td>

                            <td valign="top" class="value">${fieldValue(bean:taskRecurringScheduleInstance, field:'enabled')}</td>
                        </tr>

                        <g:if test="${taskRecurringScheduleInstance.useTargetCompletionDate}" >
                            <tr class="prop">
                                <td valign="top" class="name">Task Target Completion:</td>

                                <td valign="top" class="value">
                                    <g:formatDate date="${taskRecurringScheduleInstance.task.targetCompletionDate}"
                                                                    format="EEE, dd-MMM-yyyy"/>
                                </td>
                            </tr>
                        </g:if>

                        <tr class="prop">
                            <td valign="top" class="name">Next Generation Date:</td>

                            <td valign="top" class="value">
                                <g:formatDate date="${taskRecurringScheduleInstance.nextGenerationDate}" format="EEE, dd-MMM-yyyy"/>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Generate Ahead:</td>

                            <td valign="top" class="value">
                                ${taskRecurringScheduleInstance.generateAhead} ${Period.get(1).encodeAsHTML()}
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Next Target Start Date:</td>

                            <td valign="top" class="value">
                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetStartDate}" format="EEE, dd-MMM-yyyy"/>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Task Duration:</td>

                            <td valign="top" class="value">
                                ${taskRecurringScheduleInstance.taskDuration} ${taskRecurringScheduleInstance.taskDurationPeriod}
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Next Target Completion Date:</td>

                            <td valign="top" class="value">
                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">Note:</td>

                            <td valign="top" class="value">
                                Recurring Schedules are reviewed and Sub Tasks generated every ${grailsApplication.config.taskRecurringScheduleJob.repeatInterval.encodeAsHTML()} seconds.
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Sub Tasks Generated:</td>

                            <td valign="top" class="value">
                                ${fieldValue(bean:taskRecurringScheduleInstance, field:'subTasksGenerated')}
                            </td>
                        </tr>

                        <g:if test="${taskRecurringScheduleInstance.maxSubTasks > 0}" >
                            <tr class="prop">
                                <td valign="top" class="name">Max Sub Tasks:</td>

                                <td valign="top" class="value">
                                    ${fieldValue(bean:taskRecurringScheduleInstance, field:'maxSubTasks')}
                                </td>
                            </tr>
                        </g:if>

                        <g:if test="${taskRecurringScheduleInstance.lastGeneratedSubTask}">

                            <tr class="prop">
                                <td valign="top" class="name">Last Generated Sub Task:</td>

                                <td valign="top" class="value">
                                    <g:link controller="taskDetailed" action="show" id="${taskRecurringScheduleInstance.lastGeneratedSubTask?.id}">
                                        ${taskRecurringScheduleInstance.lastGeneratedSubTask?.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name"></td>

                                <td valign="top" class="value">
                                        ${TaskModification.findByTaskAndTaskModificationType(taskRecurringScheduleInstance.lastGeneratedSubTask, TaskModificationType.get(1))}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name"></td>

                                <td valign="top" class="value">
                                        With target start date:
                                        <g:formatDate date="${taskRecurringScheduleInstance.lastGeneratedSubTask?.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                </td>
                            </tr>

                        </g:if>

                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${taskRecurringScheduleInstance.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
<!--                     <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span> -->
                </g:form>
            </div>
        </div>
    </body>
</html>
