/**
 * External Grails application config file.
 * This is a full Groovy ConfigSlurper file but don't let that scare you :-)
 * Normally just set your database settings in the Required Settings section.
 * Usage:
 *  This file must be placed on the classpath, for example in ONE of the following:
 *   $CATALINA_BASE/lib/
 *   $CATALINA_HOME/lib/
 *   /var/lib/tomcat5.5/common/lib/ (Debian Tomcat5.5)
 *   /var/lib/tomcat6/common/classes/ (Debian Tomcat6)
 *   or in the root of a grails application (development).
 * More:
 *  Grails user guide - 3.3 The DataSource and 3.4 Externalized Configuration
 *  http://grails.org/doc/latest/guide/
 *  http://groovy.codehaus.org/ConfigSlurper
 */

/*******************
Init, please ignore.
*******************/
def appName = grails.util.Metadata.current.'app.name'
println "EXT($appName): External config start."

/***********************************
Required Settings, please set these.
************************************/

environments {
    production {
        println "EXT($appName): Configure production datasource."

        // Enable ONE dataSource with your database settings.
        // Delete dbCreate line after setup!
        dataSource {
            /** HSQLDB - In memory */
//             driverClassName = "org.hsqldb.jdbcDriver"
//             username = "sa"
//             password = ""
//             dbCreate = "create-drop"
//             url = "jdbc:hsqldb:mem:devDb"
            /** HSQLDB - In file */
//             driverClassName = "org.hsqldb.jdbcDriver"
//             username = "sa"
//             password = ""
//             dbCreate = "update"
//             url = "jdbc:hsqldb:file:prodDb;shutdown=true"
            /** MSSQL */
            //For more info see the docs that you downloaded with the driver.
//             dialect = org.hibernate.dialect.SQLServerDialect // MSSQL 2000+2005 Useful with `grails schema-export`
//             driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver"
//             username = "gnumimsadmin"
//             password = "gnumimsadmin"
//             dbCreate = "update"
//             url = "jdbc:sqlserver://gnumimssql01:1433;databaseName=gnumims_prod"
            /** MySQL */
            dialect = org.hibernate.dialect.MySQL5InnoDBDialect
            driverClassName = "com.mysql.jdbc.Driver"
            username = "gnumimsadmin"
            password = "gnumimsadmin"
            dbCreate = "update"
            url = "jdbc:mysql://gnumimssql01:3306/gnumims_prod?autoReconnect=true&sessionVariables=storage_engine=InnoDB"
        }
    }
}

// It is highly recommended to limit the currencyList to the ONE that the site uses e.g:
// 'EUR', 'XCD', 'USD', 'XOF', 'NOK', 'AUD', 'XAF', 'TRL'
// 'NZD', 'MAD', 'DKK', 'GBP', 'CHF', 'XPF', 'ILS', 'ROL'
currencyList = ['AUD']

/*******************
Optional Settings.
*******************/

 // Set true to enable demo mode and create demo data.
demoMode.enabled = false

// Task generation interval, increase value to reduce system load.
taskRecurringScheduleJob.repeatInterval = 10

/*******************
Exit Functions.
*******************/

if(demoMode.enabled) {
    println "EXT($appName): Demo mode enabled."
    currencyList = ['EUR', 'XCD', 'USD', 'XOF', 'NOK', 'AUD', 'XAF', 'TRL',
                    'NZD', 'MAD', 'DKK', 'GBP', 'CHF', 'XPF', 'ILS', 'ROL']
}

println "EXT($appName): External config end."
