class Entry {
    Person person
    Task task
    EntryType entryType
    Date date
    Integer durationHours = 0
    Integer durationMinutes = 0
    String comments

    static belongsTo = [EntryType, Task, Person]

    static constraints = {
        task()
        comments(maxSize:500)
        date()
        durationHours(min:0)
        durationMinutes(min:0,max:59)
        
    }

    String toString() {
        "${this.comments}"
    }
}

