<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Inventory Movement List</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <h1>List Inventory Movements</h1>
        </div>
        <div class="body">
             <g:link controller="inventoryItemDetailed" action="show" id="${inventoryItemInstance.id}">
                <h1>Inventory Item: ${inventoryItemInstance.name.encodeAsHTML()}.</h1>
            </g:link>
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>

            <div class="paginateButtons">
                Results:${inventoryMovementListTotal}
            </div>
            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn action="listInventoryMovements" property="quantity" title="Quantity" params="[id: inventoryItemInstance.id]"/>
                        
                   	        <g:sortableColumn action="listInventoryMovements"  property="inventoryMovementType" title="Movement Type" params="[id: inventoryItemInstance.id]" />
                        
                            <g:sortableColumn action="listInventoryMovements"  property="date" title="Date" params="[id: inventoryItemInstance.id]" />
                        
                   	        <g:sortableColumn action="listInventoryMovements"  property="person" title="Person" params="[id: inventoryItemInstance.id]" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${inventoryMovementList}" status="i" var="inventoryMovementInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'quantity')}
                            </td>
                        
                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'inventoryMovementType')}
                            </td>
                        
                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                <g:formatDate date="${inventoryMovementInstance.date}" format="EEE, dd-MMM-yyyy"/>
                            </td>
                        
                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'person')}
                            </td>

                            <td class="notClickable">
                                <g:link action="show" id="${inventoryMovementInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate action="listInventoryMovements" id="${inventoryItemInstance.id}" total="${inventoryMovementListTotal}" />
            </div>
        </div>
    </body>
</html>
