

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Person</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Person List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Person</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Person</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${personInstance}">
            <div class="errors">
                <g:renderErrors bean="${personInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${personInstance?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="firstName">First Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'firstName','errors')}">
                                    <input type="text" maxlength="50" id="firstName" name="firstName" value="${fieldValue(bean:personInstance,field:'firstName')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="lastName">Last Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'lastName','errors')}">
                                    <input type="text" maxlength="50" id="lastName" name="lastName" value="${fieldValue(bean:personInstance,field:'lastName')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="userId">User Id:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'userId','errors')}">
                                    <input type="text" maxlength="8" id="userId" name="userId" value="${fieldValue(bean:personInstance,field:'userId')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="password">Password:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'password','errors')}">
                                    <input type="text" maxlength="8" id="password" name="password" value="${fieldValue(bean:personInstance,field:'password')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="employeeID">Employee ID:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'employeeID','errors')}">
                                    <input type="text" id="employeeID" name="employeeID" value="${fieldValue(bean:personInstance,field:'employeeID')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="entries">Entries:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'entries','errors')}">
                                    
<ul>
<g:each var="e" in="${personInstance?.entries?}">
    <li><g:link controller="entry" action="show" id="${e.id}">${e?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="entry" params="['person.id':personInstance?.id]" action="create">Add Entry</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${personInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="modifications">Modifications:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'modifications','errors')}">
                                    
<ul>
<g:each var="m" in="${personInstance?.modifications?}">
    <li><g:link controller="modification" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="modification" params="['person.id':personInstance?.id]" action="create">Add Modification</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="personGroups">Person Groups:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'personGroups','errors')}">
                                    
<ul>
<g:each var="p" in="${personInstance?.personGroups?}">
    <li><g:link controller="personGroup" action="show" id="${p.id}">${p?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="personGroup" params="['person.id':personInstance?.id]" action="create">Add PersonGroup</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="tasks">Tasks:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:personInstance,field:'tasks','errors')}">
                                    
<ul>
<g:each var="t" in="${personInstance?.tasks?}">
    <li><g:link controller="task" action="show" id="${t.id}">${t?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="task" params="['person.id':personInstance?.id]" action="create">Add Task</g:link>

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
