dataSource {
	pooled = true
	driverClassName = "org.hsqldb.jdbcDriver"
	username = "sa"
	password = ""
}
hibernate {
    cache.use_second_level_cache=true
    cache.use_query_cache=true
    cache.provider_class='com.opensymphony.oscache.hibernate.OSCacheProvider'
}

//environment specific settings
//create-drop:  drop tables and data between sessions, then insert from Bootstrap.
//create:       drop data between sessions, can't explain the rest.
//update:       keep data, update tables as required, keeps inserting from BootStrap.
environments {
	development {
		dataSource {
			dbCreate = "create-drop" // one of 'create', 'create-drop','update'
			url = "jdbc:hsqldb:mem:devDB"
		}
	}
	test {
		dataSource {
			dbCreate = "update"
			url = "jdbc:hsqldb:mem:testDb"
		}
	}
	production {
		dataSource {
			//Delete dbCreate line after setup!
            dbCreate = "create-drop"
			//url = "jdbc:hsqldb:file:prodDb;shutdown=true"
            url = "jdbc:hsqldb:mem:devDB"
		}
	}
}