<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Inventory Value Report</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <h1>Inventory Value Report</h1>
            <g:render template="/shared/messages" />
            <div class="dialog">
                <table>
                    <tbody>

                        <g:jasperForm controller="report"
                                                    action="inventoryValue"
                                                    jasper="inventoryValue"
                                                    name="Inventory Value">

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Site:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:select optionKey="id"
                                                        from="${Site.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                        name="site.id">
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Inventory Type:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="inventoryTypes"
                                                                            from="${InventoryType.findAllByIsActive(true)}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="inventoryTypeDetailed"
                                                                            linkAction="show"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Inventory Group:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="inventoryGroups"
                                                                            from="${InventoryGroup.findAllByIsActive(true)}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="inventoryGroupDetailed"
                                                                            linkAction="show"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Report:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:jasperButtons formName="inventoryValue" format="PDF, XLS" text="PDF" />
                                </td>
                            </tr>

                        </g:jasperForm>

                    </tbody>
                </table>
            </div> <!--End dialog-->
        </div> <!--End body-->
    </body>
</html>
