

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryItemPurchase</title>
    </head>
    <body>
        <div class="nav">
            <h1>Edit InventoryItemPurchase</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${inventoryItemPurchaseInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemPurchaseInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryItemPurchaseInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryItemPurchaseInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                    
                            <tr class="prop">
                                <td valign="top" class="name">Inventory Item:</td>
                                
                                <td valign="top" class="value"><g:link controller="inventoryItemDetailed" action="show" id="${inventoryItemPurchaseInstance?.inventoryItem?.id}">${inventoryItemPurchaseInstance?.inventoryItem?.encodeAsHTML()}</g:link></td>
                                
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">Purchase Type:</td>
                                
                                <td valign="top" class="value">${inventoryItemPurchaseInstance?.inventoryItemPurchaseType?.encodeAsHTML()}</td>
                                
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="invoiceNumber">Purchase Order #:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'purchaseOrderNumber','errors')}">
                                    <input type="text" maxlength="50" id="purchaseOrderNumber" name="purchaseOrderNumber" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'purchaseOrderNumber')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'date','errors')}">
                                    <richui:dateChooser name="date" format="dd-MM-yyyy" value="${inventoryItemPurchaseInstance.date}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="costCode">Cost Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'costCode','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ CostCode.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        name="costCode.id"
                                                        value="${inventoryItemPurchaseInstance?.costCode?.id}" ></g:select>
                                </td>
                            </tr>
                        
                             <tr class="prop">
                                 <td valign="top" class="name">
                                    <label for="supplier">Supplier:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'supplier','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ Supplier.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        name="supplier.id"
                                                        value="${inventoryItemPurchaseInstance?.supplier?.id}"
                                                        noSelection="['null':/${g.message(code:'default.please.select.text')}/]">
                                    </g:select>
                                    <p><g:link controller="supplierDetailed" action="create">+Add Supplier</g:link></p>
                                </td>
                            </tr>
                    
                            <tr class="prop">
                                <td valign="top" class="name">Quantity:</td>
                                
                                <td valign="top" class="value">${fieldValue(bean:inventoryItemPurchaseInstance, field:'quantity')}</td>
                                
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="orderValueAmount">Order Value:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'orderValueAmount','errors')}">
                                    <input type="text" id="orderValueAmount" name="orderValueAmount" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'orderValueAmount')}" />
                                    <g:currencySelect name="orderValueCurrency"
                                                                        value="${inventoryItemPurchaseInstance?.orderValueCurrency}"
                                                                        from="${grailsApplication.config.currencyList}">
                                    </g:currencySelect>
                                </td>
                            </tr>

                            <g:if test="${inventoryItemPurchaseInstance.inventoryItemPurchaseType?.id == 4}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="invoiceNumber">Invoice Number:</label>
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'invoiceNumber','errors')}">
                                        <input type="text" maxlength="50" id="invoiceNumber" name="invoiceNumber" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'invoiceNumber')}"/>
                                    </td>
                                </tr>
                            </g:if>

                            <g:if test="${inventoryItemPurchaseInstance?.inventoryItemPurchaseType?.id > 0}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="receivedComplete">Received Complete:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:checkBox name="receivedComplete" value="${inventoryItemPurchaseInstance?.receivedComplete}" ></g:checkBox>
                                    </td>
                                </tr>
                                
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="invoicePaymentApproved">Invoice Payment Approved:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:checkBox name="invoicePaymentApproved" value="${inventoryItemPurchaseInstance?.invoicePaymentApproved}" ></g:checkBox>
                                    </td>
                                </tr>
                            </g:if>
                            <g:else>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="receivedComplete">Received Complete:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        ${fieldValue(bean:inventoryItemPurchaseInstance, field:'receivedComplete')}
                                    </td>
                                </tr>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="invoicePaymentApproved">Invoice Payment Approved:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        ${fieldValue(bean:inventoryItemPurchaseInstance, field:'invoicePaymentApproved')}
                                    </td>
                                </tr>
                            </g:else>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:inventoryItemPurchaseInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">Entered By:</td>
                            <td valign="top" class="value">
                                <g:link controller="person" action="show" id="${inventoryItemPurchaseInstance?.enteredBy?.id}">
                                    ${inventoryItemPurchaseInstance?.enteredBy?.encodeAsHTML()}
                                </g:link>
                                    on <g:formatDate date="${inventoryItemPurchaseInstance?.dateCreated}" format="EEE, dd-MMM-yyyy @ HH:mm"/>
                            </td>
                        </tr>

                        <g:if test="${inventoryItemPurchaseInstance.lastUpdatedBy}">
                            <tr class="prop">
                                <td valign="top" class="name">Last Updated By:</td>
                                <td valign="top" class="value">
                                    <g:link controller="person" action="show" id="${inventoryItemPurchaseInstance?.lastUpdatedBy?.id}">
                                        ${inventoryItemPurchaseInstance?.lastUpdatedBy.encodeAsHTML()}
                                    </g:link>
                                    on <g:formatDate date="${inventoryItemPurchaseInstance?.lastUpdated}" format="EEE, dd-MMM-yyyy @ HH:mm"/>
                                </td>
                            </tr>
                        </g:if >
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
