class InventoryItemPurchase {

    Person enteredBy
    InventoryItem inventoryItem
    CostCode costCode
    InventoryItemPurchaseType inventoryItemPurchaseType

    Date dateEntered = new Date()
    Integer quantity
    String purchaseOrderNumber = ''
    BigDecimal orderValueAmount
    Currency orderValueCurrency
    String invoiceNumber = ''

    Boolean receivedComplete = false
    Boolean invoicePaymentApproved = false

//     hasMany = []

    static belongsTo = [InventoryItem]

    static constraints = {
        quantity(min:0)
        purchaseOrderNumber(blank:false, maxSize:50)
        invoiceNumber(maxSize:50)
        orderValueAmount(max: new BigDecimal(1000000000000))
        orderValueCurrency()
    }

    String toString() {
        "${this.quantity} x ${inventoryItem} - ${this.inventoryItemPurchaseType} "
    }

}