import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class MaintenanceActionDetailedController extends BaseController {

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ maintenanceActionInstanceList: MaintenanceAction.list( params ), maintenanceActionInstanceTotal: MaintenanceAction.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {
        def maintenanceActionInstance = MaintenanceAction.get( params.id )

        if(!maintenanceActionInstance) {
            flash.message = "MaintenanceAction not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ maintenanceActionInstance : maintenanceActionInstance ] }
    }

    def delete = {
        def maintenanceActionInstance = MaintenanceAction.get( params.id )
        if(maintenanceActionInstance) {
            try {
                maintenanceActionInstance.delete(flush:true)
                flash.message = "MaintenanceAction ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "MaintenanceAction ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "MaintenanceAction not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def maintenanceActionInstance = MaintenanceAction.get( params.id )

        if(!maintenanceActionInstance) {
            flash.message = "MaintenanceAction not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ maintenanceActionInstance : maintenanceActionInstance ]
        }
    }

    def update = {
        def maintenanceActionInstance = MaintenanceAction.get( params.id )
        if(maintenanceActionInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(maintenanceActionInstance.version > version) {
                    
                    maintenanceActionInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[maintenanceActionInstance:maintenanceActionInstance])
                    return
                }
            }
            maintenanceActionInstance.properties = params
            if(!maintenanceActionInstance.hasErrors() && maintenanceActionInstance.save(flush: true)) {
                flash.message = "MaintenanceAction ${params.id} updated"
                redirect(action:show,id:maintenanceActionInstance.id)
            }
            else {
                render(view:'edit',model:[maintenanceActionInstance:maintenanceActionInstance])
            }
        }
        else {
            flash.message = "MaintenanceAction not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def maintenanceActionInstance = new MaintenanceAction()
        maintenanceActionInstance.properties = params
        return ['maintenanceActionInstance':maintenanceActionInstance]
    }

    def save = {
        def maintenanceActionInstance = new MaintenanceAction(params)
        if(!maintenanceActionInstance.hasErrors() && maintenanceActionInstance.save(flush: true)) {
            flash.message = "MaintenanceAction ${maintenanceActionInstance.id} created"
            redirect(action:show,id:maintenanceActionInstance.id)
        }
        else {
            render(view:'create',model:[maintenanceActionInstance:maintenanceActionInstance])
        }
    }
}
