

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Contact</title>
    </head>
    <body>
        <div class="nav">
            <h1>Create Contact</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${contactInstance}">
            <div class="errors">
                <g:renderErrors bean="${contactInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>

                            <g:if test="${contactInstance.manufacturer}">
                                <g:hiddenField name="manufacturer.id" value="${contactInstance.manufacturer.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="manufacturer">Manufacturer:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="manufacturerDetailed" action="show" id="${contactInstance.manufacturer.id}">
                                            ${contactInstance.manufacturer.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>
                            
                            <g:if test="${contactInstance.supplier}">
                                <g:hiddenField name="supplier.id" value="${contactInstance.supplier.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="supplier">Supplier:</label>
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:contactInstance,field:'supplier','errors')}">
                                        <g:link controller="supplierDetailed" action="show" id="${contactInstance.supplier.id}">
                                            ${contactInstance.supplier.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>
                            
                            <g:if test="${contactInstance.person}">
                                <g:hiddenField name="person.id" value="${contactInstance.person.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="person">Person:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="person" action="show" id="${contactInstance.person.id}">
                                            ${contactInstance.person.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr> 
                            </g:if>
                            
                            <g:if test="${contactInstance.site}">
                                <g:hiddenField name="site.id" value="${contactInstance.site.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="site">Site:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="siteDetailed" action="show" id="${contactInstance.site.id}">
                                            ${contactInstance.site.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr> 
                            </g:if>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="contactType">Contact Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:contactInstance,field:'contactType','errors')}">
                                    <g:select optionKey="id" from="${ContactType.list()}" name="contactType.id" value="${contactInstance?.contactType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="email">Value:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:contactInstance,field:'value','errors')}">
                                    <input type="text" id="value" name="value" value="${fieldValue(bean:contactInstance,field:'value')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
