class ModificationTypeController extends BaseController {

    def beforeInterceptor = [action:this.&auth]

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ modificationTypeInstanceList: ModificationType.list( params ) ]
    }

    def show = {
        def modificationTypeInstance = ModificationType.get( params.id )

        if(!modificationTypeInstance) {
            flash.message = "ModificationType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ modificationTypeInstance : modificationTypeInstance ] }
    }

    def delete = {
        def modificationTypeInstance = ModificationType.get( params.id )
        if(modificationTypeInstance) {
            modificationTypeInstance.delete()
            flash.message = "ModificationType ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "ModificationType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def modificationTypeInstance = ModificationType.get( params.id )

        if(!modificationTypeInstance) {
            flash.message = "ModificationType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ modificationTypeInstance : modificationTypeInstance ]
        }
    }

    def update = {
        def modificationTypeInstance = ModificationType.get( params.id )
        if(modificationTypeInstance) {
            modificationTypeInstance.properties = params
            if(!modificationTypeInstance.hasErrors() && modificationTypeInstance.save()) {
                flash.message = "ModificationType ${params.id} updated"
                redirect(action:show,id:modificationTypeInstance.id)
            }
            else {
                render(view:'edit',model:[modificationTypeInstance:modificationTypeInstance])
            }
        }
        else {
            flash.message = "ModificationType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def modificationTypeInstance = new ModificationType()
        modificationTypeInstance.properties = params
        return ['modificationTypeInstance':modificationTypeInstance]
    }

    def save = {
        def modificationTypeInstance = new ModificationType(params)
        if(!modificationTypeInstance.hasErrors() && modificationTypeInstance.save()) {
            flash.message = "ModificationType ${modificationTypeInstance.id} created"
            redirect(action:show,id:modificationTypeInstance.id)
        }
        else {
            render(view:'create',model:[modificationTypeInstance:modificationTypeInstance])
        }
    }
}
