import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager'])
class ContactDetailedController extends BaseController {

    def contactService

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AppUser'])
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AppUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ contactInstanceList: Contact.list( params ), contactInstanceTotal: Contact.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AppUser'])
    def show = {
        def contactInstance = Contact.get( params.id )

        if(!contactInstance) {
            flash.message = "Contact not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ contactInstance : contactInstance ] }
    }

    def delete = {
        def result = contactService.delete(params)

        if(!result.error) {
            if(result.ownerInstance) {
                def c = getControllerName(result.ownerInstance)
                flash.message = g.message(code: "default.delete.success", args: ["Contact", ''])
                redirect(controller:c, action:'edit', id: result.ownerInstance.id)
                return
            }
            flash.message = g.message(code: "default.delete.success", args: ["Contact", params.id])
            redirect(action:list)
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(action:list)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def contactInstance = Contact.get( params.id )

        if(!contactInstance) {
            flash.message = "Contact not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ contactInstance : contactInstance ]
        }
    }

    def update = {
        def contactInstance = Contact.get( params.id )
        if(contactInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(contactInstance.version > version) {

                    contactInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[contactInstance:contactInstance])
                    return
                }
            }
            contactInstance.properties = params
            if(!contactInstance.hasErrors() && contactInstance.save(flush: true)) {
                flash.message = "Contact ${params.id} updated"
                redirect(action:show,id:contactInstance.id)
            }
            else {
                render(view:'edit',model:[contactInstance:contactInstance])
            }
        }
        else {
            flash.message = "Contact not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def result = contactService.create(params)

        if(!result.error)
            return [contactInstance: result.contactInstance]

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)
        redirect(action: list)
    }

    def save = {
        def result = contactService.save(params)

        if(!result.error) {
            def c = getControllerName(result.ownerInstance)
            flash.message = g.message(code: "default.create.success", args: ["Contact", ''])
            redirect(controller:c, action:'edit', id: result.ownerInstance.id)
            return
        }

        render(view:'create', model:[contactInstance: result.contactInstance])
    }

    private getControllerName(ownerInstance) {
        if(ownerInstance.class.name == 'Person')
            return "${ownerInstance.class.name[0].toLowerCase() + ownerInstance.class.name[1..-1]}"
        else
            return "${ownerInstance.class.name[0].toLowerCase() + ownerInstance.class.name[1..-1]}"+"Detailed"
    }

}
