

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show InventoryItem</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${inventoryMovementInstance}">
                <div class="errors">
                    <g:renderErrors bean="${inventoryMovementInstance}" as="list" />
                </div>
            </g:hasErrors>

            <g:hasErrors bean="${inventoryItemInstance}">
                <div class="errors">
                    <g:renderErrors bean="${inventoryItemInstance}" as="list" />
                </div>
            </g:hasErrors>

            <div class="tabHeader">
                <h1 class="taskHeader">
                    ${inventoryItemInstance.name}
                </h1>
                ${fieldValue(bean:inventoryItemInstance, field:'description')}
            </div>

            <br/>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTab.inventory}" title="Inventory Item" />
                    <richui:tabLabel selected="${showTab.detail}" title="Detail" />
                    <richui:tabLabel selected="${showTab.movement}" title="Movement" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Start Inventory tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementInstance}" >

                            <g:form controller="inventoryItemDetailed" method="post" >
                                <div class="dialog">
                                    <table>
                                        <tbody>
                                                <g:hiddenField name="task.id" value="${inventoryMovementInstance.task.id}"/>
                                                <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}"/>
                                                <tr class="prop">
                                                    <td valign="top" class="name">Use on task:</td>
                                                    <td valign="top" class="value">
                                                        <g:link controller="taskDetailed" action="show" id="${inventoryMovementInstance.task.id}" >
                                                            ${Task.get(inventoryMovementInstance.task.id).encodeAsHTML()}
                                                        </g:link>
                                                    </td>
                                                </tr>

                                                <tr class="prop">
                                                    <td valign="top" class="name">
                                                        <label for="quantity">Quantity:</label>
                                                    </td>
                                                    <td valign="top">
                                                        <input class="medium ${hasErrors(bean:inventoryMovementInstance,field:'quantity','errors')}"
                                                                    type="text" id="quantity" name="quantity"
                                                                    value="${fieldValue(bean:inventoryMovementInstance,field:'quantity')}"/>
                                                        ${inventoryItemInstance.unitOfMeasure?.encodeAsHTML()}

                                                        <span class="buttons">
                                                            <g:actionSubmit action="useInventoryItem" class="save" value="${InventoryMovementType.get(1)}" />
                                                        </span>

                                                    </td>
                                                </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </g:form>

                            <br />

                        </g:if>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">Picture:</td>
                                        <td valign="top" class="value">
                                            <g:if test="${inventoryItemInstance.picture}" >
                                                <span class='gallery'><wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" /></span>
                                            </g:if>
                                            <g:else>
                                                <g:link controller="pictureDetailed"
                                                                params="['inventoryItem.id':inventoryItemInstance.id]"
                                                                action="create">
                                                    Add Picture
                                                </g:link>
                                            </g:else>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Comment:</td>

                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'comment')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">In Stock:</td>

                                        <td valign="top" class="value">
                                            ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')} ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Location:</td>

                                        <td valign="top" class="value">
                                            <g:link controller="inventoryLocationDetailed" action="show" id="${inventoryItemInstance.inventoryLocation?.id}">
                                                ${inventoryItemInstance.inventoryLocation?.encodeAsHTML()}
                                            </g:link>
                                                in ${inventoryItemInstance.inventoryLocation?.inventoryStore.encodeAsHTML()}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Active:</td>

                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isActive')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Items:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${ inventoryItemInstance.alternateItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="inventoryItemDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Spare For:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="s" in="${ inventoryItemInstance.spareFor.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="assetDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="buttons">
                            <g:form>
                                <g:hiddenField name="id" value="${inventoryItemInstance.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>

                        <br />

                    </richui:tabContent>
<!-- End Inventory tab -->

<!-- Start Detail tab -->
                    <richui:tabContent>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">Id:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'id')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Obsolete:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isObsolete')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Inventory Group:</td>
                                        <td valign="top" class="value">${inventoryItemInstance.inventoryGroup?.encodeAsHTML()}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Inventory Type:</td>
                                        <td valign="top" class="value">${inventoryItemInstance.inventoryType?.encodeAsHTML()}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Reorder Point:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'reorderPoint')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Enable Reorder:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'enableReorder')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Recommended Reorder Point:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'recommendedReorderPoint')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Estimated Unit Price:</td>

                                        <td valign="top" class="value">
                                            <g:if test="${inventoryItemInstance.estimatedUnitPriceAmount}">
                                                ${inventoryItemInstance.estimatedUnitPriceAmount.encodeAsHTML()}
                                                ${inventoryItemInstance.estimatedUnitPriceCurrency.encodeAsHTML()}
                                            </g:if>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Suppliers Part Number:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'suppliersPartNumber')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Preferred Supplier:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <g:link controller="supplierDetailed" action="show" id="${inventoryItemInstance.preferredSupplier?.id}">
                                                ${inventoryItemInstance.preferredSupplier?.encodeAsHTML()}
                                            </g:link>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Suppliers:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="s" in="${ inventoryItemInstance.alternateSuppliers.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="supplierDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Average Delivery Time:</td>
                                        <td valign="top" class="value">
                                        ${fieldValue(bean:inventoryItemInstance, field:'averageDeliveryTime')}
                                        ${fieldValue(bean:inventoryItemInstance, field:'averageDeliveryPeriod')}
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Manufacturers Part Number:</td>
                                        <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'manufacturersPartNumber')}</td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Preferred Manufacturer:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <g:link controller="manufacturerDetailed" action="show" id="${inventoryItemInstance.preferredManufacturer?.id}">
                                                ${inventoryItemInstance.preferredManufacturer?.encodeAsHTML()}
                                            </g:link>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Alternate Manufacturers:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="m" in="${ inventoryItemInstance.alternateManufacturers.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }">
                                                <li><g:link controller="manufacturerDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                        </td>
                                    </tr>


                                </tbody>
                            </table>
                        </div>
                        <div class="buttons">
                            <g:form>
                                <g:hiddenField name="id" value="${inventoryItemInstance.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>
                    </richui:tabContent>
<!-- End Detail tab -->

<!-- Start Movement tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementList.isEmpty()}">
                            <br />
                            No Inventory Movements.
                            <br />
                            <br />

                            <div class="buttons">
                                <g:form controller="inventoryMovementDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Create" /></span>
                                </g:form>
                            </div>

                        </g:if>
                        <g:else>

                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Quantity</th>
                                            <th>Movement Type</th>
                                            <th>Date</th>
                                            <th>Person</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${inventoryMovementList}" status="i" var="movements">
                                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${movements.id}"'/>

                                                <td>${fieldValue(bean:movements, field:'quantity')}</td>
                                                <td>${fieldValue(bean:movements, field:'inventoryMovementType')}</td>
                                                <td><g:formatDate date="${movements.date}" format="EEE, dd-MMM-yyyy"/></td>
                                                <td>${fieldValue(bean:movements, field:'person')}</td>
                                                <td>
                                                    <g:link controller="inventoryMovementDetailed" action="show" id="${movements.id}">
                                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                                    </g:link>
                                                </td>

                                            </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>

                            <div class="buttons">
                                <g:form controller="inventoryMovementDetailed">
                                    <g:hiddenField name="inventoryItem.id" value="${inventoryItemInstance.id}" />
                                    <g:if test="${inventoryMovementListTotal > inventoryMovementListMax}">
                                        Showing ${inventoryMovementListMax} of ${inventoryMovementListTotal}
                                        <br />
                                    </g:if>
                                    <g:else>
                                        Total ${inventoryMovementListTotal}
                                        <br />
                                    </g:else>
                                    <span class="button"><g:actionSubmit action="listInventoryMovements" class="table" value="List" /></span>
                                    <span class="button"><g:actionSubmit action="create" class="add" value="Create" /></span>
                                </g:form>
                            </div>

                        </g:else>

                    </richui:tabContent>
<!-- End Movement tab -->

                </richui:tabContents>
            </richui:tabView>


        </div>
    </body>
</html>
