class Task {

    TaskGroup taskGroup
    TaskStatus taskStatus
    TaskPriority taskPriority
    TaskBudgetStatus taskBudgetStatus
    TaskType taskType
    Task parentTask
    Person leadPerson
    Asset primaryAsset
    TaskRecurringSchedule taskRecurringSchedule
    TaskProcedure taskProcedure

    String description
    String comment = ""
    Date targetStartDate = new Date()
    Date targetCompletionDate = new Date()
    boolean scheduled = false
    boolean approved = false
    boolean trash = false
    boolean attentionFlag = false

    static hasMany = [entries: Entry,
                        taskModifications: TaskModification,
                        assignedGroups: AssignedGroup,
                        assignedPersons: AssignedPerson,
                        subTasks: Task,
                        associatedAssets: Asset,
                        inventoryMovements: InventoryMovement]

    static mappedBy = [taskRecurringSchedule:"task"]

    static belongsTo = [TaskGroup, TaskStatus, Task, Person]

    static constraints = {
        description(blank:false,maxSize:75)
        comment()
        targetStartDate()
        targetCompletionDate()
        leadPerson()
        taskPriority()
        taskBudgetStatus()
        taskStatus()
        parentTask(nullable:true)
        primaryAsset(nullable:true)
        taskRecurringSchedule(nullable:true)
        taskProcedure(nullable:true)

    }

    String toString() {"${this.id} - ${this.description}"}
}
