

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create InventoryItem</title>    
        <nav:resources override="true"/>     
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${inventoryItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:inventoryItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'description','errors')}">
                                    <input type="text" class="description" id="description" name="description" value="${fieldValue(bean:inventoryItemInstance,field:'description')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryLocation">Inventory Location:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryLocation','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ InventoryLocation.list().sort { p1, p2 -> p1.toString().compareToIgnoreCase(p2.toString()) } }"
                                                        name="inventoryLocation.id" value="${inventoryItemInstance?.inventoryLocation?.id}"
                                                        optionValue="${{it.name+ ' in ' + it.inventoryStore}}">
                                    </g:select>

                                <p><g:link controller="inventoryLocationDetailed" action="create">+Add Location</g:link></p>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="reorderPoint">Reorder Point:</label>
                                </td>
                                <td valign="top">
                                    <input class="medium ${hasErrors(bean:inventoryItemInstance,field:'reorderPoint','errors')}"
                                                    type="text" id="reorderPoint" name="reorderPoint"
                                                    value="${fieldValue(bean:inventoryItemInstance,field:'reorderPoint')}" />
                                    <g:select optionKey="id"
                                                        from="${UnitOfMeasure.list()}"
                                                        name="unitOfMeasure.id"
                                                        value="${inventoryItemInstance?.unitOfMeasure?.id}" >
                                    </g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enableReorder">Enable Reorder:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'enableReorder','errors')}">
                                    <g:checkBox name="enableReorder" value="${inventoryItemInstance?.enableReorder}" ></g:checkBox>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryGroup">Inventory Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryGroup','errors')}">
                                    <g:select optionKey="id" from="${InventoryGroup.list()}" name="inventoryGroup.id" value="${inventoryItemInstance?.inventoryGroup?.id}" ></g:select>

                                <p><g:link controller="inventoryGroupDetailed" action="create">+Add Group</g:link></p>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryType">Inventory Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryType','errors')}">
                                    <g:select optionKey="id" from="${InventoryType.list()}" name="inventoryType.id" value="${inventoryItemInstance?.inventoryType?.id}" ></g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Average Delivery Time:</label>
                                </td>
                                <td valign="top">
                                    <input  class="medium ${hasErrors(bean:inventoryItemInstance,field:'averageDeliveryTime','errors')}"
                                                    type="text" id="averageDeliveryTime" name="averageDeliveryTime"
                                                    value="${fieldValue(bean:inventoryItemInstance,field:'averageDeliveryTime')}" />
                                    <g:select optionKey="id" from="${Period.list()}" name="averageDeliveryPeriod.id" value="${inventoryItemInstance?.averageDeliveryPeriod?.id}" noSelection="['null':'--None--']"></g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Estimated Unit Price:</label>
                                </td>
                                <td valign="top">
                                    <input  class="medium ${hasErrors(bean:inventoryItemInstance,field:'estimatedUnitPriceAmount','errors')}"
                                                    type="text" id="estimatedUnitPriceAmount" name="estimatedUnitPriceAmount"
                                                    value="${fieldValue(bean:inventoryItemInstance,field:'estimatedUnitPriceAmount')}" />
                                    <g:currencySelect name="estimatedUnitPriceCurrency"
                                                                        value="${inventoryItemInstance.estimatedUnitPriceCurrency}" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliersPartNumber">Suppliers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliersPartNumber','errors')}">
                                    <input type="text" id="suppliersPartNumber" name="suppliersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'suppliersPartNumber')}"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliers">Suppliers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliers','errors')}">
                                    <g:select id="suppliers" name="suppliers"
                                                        from="${ Supplier.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.suppliers?.id}" noSelection="['':'--None--']"/>

                                <p><g:link controller="supplierDetailed" action="create">+Add Supplier</g:link></p>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturersPartNumber">Manufacturers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturersPartNumber','errors')}">
                                    <input type="text" id="manufacturersPartNumber" name="manufacturersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'manufacturersPartNumber')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturers">Manufacturers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturers','errors')}">
                                    <g:select id="manufacturers" name="manufacturers"
                                                        from="${ Manufacturer.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.manufacturers?.id}" noSelection="['':'--None--']" />

                                    <p><g:link controller="manufacturerDetailed" action="create">+Add Manufacturer</g:link></p>
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
