import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class SupplierTypeDetailedController extends BaseController {

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ supplierTypeInstanceList: SupplierType.list( params ), supplierTypeInstanceTotal: SupplierType.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def supplierTypeInstance = SupplierType.get( params.id )

        if(!supplierTypeInstance) {
            flash.message = "SupplierType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ supplierTypeInstance : supplierTypeInstance ] }
    }

    def delete = {
        def supplierTypeInstance = SupplierType.get( params.id )
        if(supplierTypeInstance) {
            try {
                supplierTypeInstance.delete(flush:true)
                flash.message = "SupplierType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "SupplierType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "SupplierType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def supplierTypeInstance = SupplierType.get( params.id )

        if(!supplierTypeInstance) {
            flash.message = "SupplierType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ supplierTypeInstance : supplierTypeInstance ]
        }
    }

    def update = {
        def supplierTypeInstance = SupplierType.get( params.id )
        if(supplierTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(supplierTypeInstance.version > version) {
                    
                    supplierTypeInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[supplierTypeInstance:supplierTypeInstance])
                    return
                }
            }
            supplierTypeInstance.properties = params
            if(!supplierTypeInstance.hasErrors() && supplierTypeInstance.save(flush: true)) {
                flash.message = "SupplierType ${params.id} updated"
                redirect(action:show,id:supplierTypeInstance.id)
            }
            else {
                render(view:'edit',model:[supplierTypeInstance:supplierTypeInstance])
            }
        }
        else {
            flash.message = "SupplierType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def supplierTypeInstance = new SupplierType()
        supplierTypeInstance.properties = params
        return ['supplierTypeInstance':supplierTypeInstance]
    }

    def save = {
        def supplierTypeInstance = new SupplierType(params)
        if(!supplierTypeInstance.hasErrors() && supplierTypeInstance.save(flush: true)) {
            flash.message = "SupplierType ${supplierTypeInstance.id} created"
            redirect(action:show,id:supplierTypeInstance.id)
        }
        else {
            render(view:'create',model:[supplierTypeInstance:supplierTypeInstance])
        }
    }
}
