<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task List</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <div class="list">
                <table>
                    <thead>
                        <tr>

                            <g:sortableColumn defaultOrder="desc" property="id" title="Id"  />

                            <g:sortableColumn property="targetStartDate" title="Target Start Date" />

                            <g:sortableColumn property="description" title="Description" />

                            <g:sortableColumn  property="leadPerson" title="Lead Person" />

                            <g:sortableColumn  property="taskPriority" title="Task Priority" />

                            <g:sortableColumn  property="taskStatus" title="Task Status" />

                            <th></th>

                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                            <td>${fieldValue(bean:taskInstance, field:'id')}</td>

                            <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                            <td>${fieldValue(bean:taskInstance, field:'description')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'leadPerson')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                            <td>
                                <g:link action="show" id="${taskInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>

                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${taskInstanceTotal}" />
            </div>
        </div>
    </body>
</html>
