/**
* Asset Tree tags.
* Specific to gnuMims hence the namespace.
*/
class AssetTreeTagLib {
    static namespace = 'gnuMims'

    def js = new JsUtilService()
    def ts = new AssetTreeService()

    /**
    * Include required javascript and do setup here.
    */
    def resources = { attrs ->
        out << g.javascript(src: "assetTree.js")
    }

    /**
    * Button that opens the asset tree pane and calls the javascript to populate it.
    */
    def assetTreeButton = { attrs ->
        def mkp = new groovy.xml.MarkupBuilder(out) //this line will be unnecessary in versions of Grails after version 1.2

        mkp.div( class: ts.buttonHtmlClass() ) {
            a( href: ts.hrefShowPane() ) {
                img(src: ts.treeRootImg())
            }
        } // mkp
    } // assetTreeButton

    /**
    * The asset tree pane, ready for populating by an ajax call to AssetTreeSevice.
    */
    def assetTreePane = { attrs ->
        def mkp = new groovy.xml.MarkupBuilder(out) //this line will be unnecessary in versions of Grails after version 1.2

        mkp.div(class: ts.paneHtmlClass(), id: ts.paneHtmlId(), style: 'display:none;') {
            div(class: ts.paneCloseHtmlClass()) {
                a( href: js.toggle(ts.paneHtmlId()) ) {
                    img(src: ts.closeImg())
                }
            }

            div(class: ts.tableDivHtmlClass()) {
                table(id: ts.tableHtmlId()) {
                    tr() {
                        td(valign: 'top', class: 'value') {
                            ul() {
                                img(src: ts.treeRootImg(), id: ts.tableLoadingImgId(), alt: 'TreeRoot')
                                li() {
                                } // li
                            } // ul
                        } // td
                    } // tr
                } // table
            } // div
        } // mkp
    } // assetTreePane

} // end class