import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskProcedureController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskProcedureInstanceList: TaskProcedure.list( params ), taskProcedureInstanceTotal: TaskProcedure.count() ]
    }

    def show = {
        def taskProcedureInstance = TaskProcedure.get( params.id )

        if(!taskProcedureInstance) {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskProcedureInstance : taskProcedureInstance ] }
    }

    def delete = {
        def taskProcedureInstance = TaskProcedure.get( params.id )
        if(taskProcedureInstance) {
            try {
                taskProcedureInstance.delete(flush:true)
                flash.message = "TaskProcedure ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskProcedure ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskProcedureInstance = TaskProcedure.get( params.id )

        if(!taskProcedureInstance) {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskProcedureInstance : taskProcedureInstance ]
        }
    }

    def update = {
        def taskProcedureInstance = TaskProcedure.get( params.id )
        if(taskProcedureInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskProcedureInstance.version > version) {
                    
                    taskProcedureInstance.errors.rejectValue("version", "taskProcedure.optimistic.locking.failure", "Another user has updated this TaskProcedure while you were editing.")
                    render(view:'edit',model:[taskProcedureInstance:taskProcedureInstance])
                    return
                }
            }
            taskProcedureInstance.properties = params
            if(!taskProcedureInstance.hasErrors() && taskProcedureInstance.save(flush: true)) {
                flash.message = "TaskProcedure ${params.id} updated"
                redirect(action:show,id:taskProcedureInstance.id)
            }
            else {
                render(view:'edit',model:[taskProcedureInstance:taskProcedureInstance])
            }
        }
        else {
            flash.message = "TaskProcedure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskProcedureInstance = new TaskProcedure()
        taskProcedureInstance.properties = params
        return ['taskProcedureInstance':taskProcedureInstance]
    }

    def save = {
        def taskProcedureInstance = new TaskProcedure(params)
        if(!taskProcedureInstance.hasErrors() && taskProcedureInstance.save(flush: true)) {
            flash.message = "TaskProcedure ${taskProcedureInstance.id} created"
            redirect(action:show,id:taskProcedureInstance.id)
        }
        else {
            render(view:'create',model:[taskProcedureInstance:taskProcedureInstance])
        }
    }
}
