class AssetSubItem {

    AssetSubItem parentItem

    String name
    String description = ""
    String comment = ""
    boolean isActive = true

    static hasMany = [assets: Asset,
                                subItems: AssetSubItem,
                                maintenanceActions: MaintenanceAction,
                                assetSubItemExtendedAttributes: AssetSubItemExtendedAttribute]

    static belongsTo = [Asset, AssetSubItem]

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:75)
        comment(maxSize:500)
        isActive()
        parentItem(nullable:true)
    }

    String toString() {
        "${this.name}"
    }
}

