import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryMovementController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryMovementInstanceList: InventoryMovement.list( params ), inventoryMovementInstanceTotal: InventoryMovement.count() ]
    }

    def show = {
        def inventoryMovementInstance = InventoryMovement.get( params.id )

        if(!inventoryMovementInstance) {
            flash.message = "InventoryMovement not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryMovementInstance : inventoryMovementInstance ] }
    }

    def delete = {
        def inventoryMovementInstance = InventoryMovement.get( params.id )
        if(inventoryMovementInstance) {
            try {
                inventoryMovementInstance.delete(flush:true)
                flash.message = "InventoryMovement ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryMovement ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryMovement not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryMovementInstance = InventoryMovement.get( params.id )

        if(!inventoryMovementInstance) {
            flash.message = "InventoryMovement not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryMovementInstance : inventoryMovementInstance ]
        }
    }

    def update = {
        def inventoryMovementInstance = InventoryMovement.get( params.id )
        if(inventoryMovementInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryMovementInstance.version > version) {
                    
                    inventoryMovementInstance.errors.rejectValue("version", "inventoryMovement.optimistic.locking.failure", "Another user has updated this InventoryMovement while you were editing.")
                    render(view:'edit',model:[inventoryMovementInstance:inventoryMovementInstance])
                    return
                }
            }
            inventoryMovementInstance.properties = params
            if(!inventoryMovementInstance.hasErrors() && inventoryMovementInstance.save(flush: true)) {
                flash.message = "InventoryMovement ${params.id} updated"
                redirect(action:show,id:inventoryMovementInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryMovementInstance:inventoryMovementInstance])
            }
        }
        else {
            flash.message = "InventoryMovement not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryMovementInstance = new InventoryMovement()
        inventoryMovementInstance.properties = params
        return ['inventoryMovementInstance':inventoryMovementInstance]
    }

    def save = {
        def inventoryMovementInstance = new InventoryMovement(params)
        if(!inventoryMovementInstance.hasErrors() && inventoryMovementInstance.save(flush: true)) {
            flash.message = "InventoryMovement ${inventoryMovementInstance.id} created"
            redirect(action:show,id:inventoryMovementInstance.id)
        }
        else {
            render(view:'create',model:[inventoryMovementInstance:inventoryMovementInstance])
        }
    }
}
